/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.datascope.plugin.mybatis.handler;

import com.jxdinfo.hussar.platform.core.config.HussarCoreProperties;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.ObjectUtil;
import com.jxdinfo.hussar.support.datascope.core.enums.DataScopeEnum;
import com.jxdinfo.hussar.support.datascope.core.exception.DataScopeException;
import com.jxdinfo.hussar.support.datascope.core.support.extend.cache.CustomDataScopeTableInfoCache;
import com.jxdinfo.hussar.support.datascope.core.support.extend.util.DataScopeUtil;
import com.jxdinfo.hussar.support.datascope.core.support.handler.DataScopeHandler;
import com.jxdinfo.hussar.support.datascope.core.support.model.CustomSqlCondition;
import com.jxdinfo.hussar.support.datascope.core.support.model.DataScopeInfo;
import com.jxdinfo.hussar.support.datascope.core.support.model.DataScopeModel;
import com.jxdinfo.hussar.support.datascope.core.support.service.base.DataScopeService;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperationList;
import org.apache.ibatis.executor.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class DefaultDataScopeHandler
implements DataScopeHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataScopeHandler.class);
    private final DataScopeService dataScopeService;
    private final String serverName;

    public DefaultDataScopeHandler(DataScopeService dataScopeService, HussarCoreProperties hussarCoreProperties, Environment environment) {
        this.dataScopeService = dataScopeService;
        this.serverName = hussarCoreProperties.isEnableMicroService() ? environment.getProperty("spring.application.name") : null;
    }

    public String sqlCondition(Executor executor, Object parameter, String mapperId, DataScopeModel dataScopeModel, UserDetails userDetails, String originalSql) {
        List dataScopeInfos = this.dataScopeService.getDataScope(userDetails.getUserId(), mapperId, this.serverName);
        DataScopeInfo defaultDataScope = DataScopeUtil.getDefaultDataScope((List)dataScopeInfos);
        List customDataScopes = DataScopeUtil.getEffectCustomDataScopes((List)dataScopeInfos);
        if (HussarUtils.isEmpty((Object)defaultDataScope) && HussarUtils.isNotEmpty((Object)dataScopeModel)) {
            defaultDataScope = this.toDataScopeInfo(dataScopeModel, userDetails.getUserId());
        }
        if (HussarUtils.isEmpty((Object)defaultDataScope) && HussarUtils.isEmpty((Object)customDataScopes)) {
            return null;
        }
        return this.sqlPackage(executor, parameter, userDetails, defaultDataScope, customDataScopes, originalSql);
    }

    public DataScopeInfo toDataScopeInfo(DataScopeModel dataScope, Long userId) {
        DataScopeInfo dataScopeInfo = new DataScopeInfo();
        ArrayList<Integer> scopeTypes = new ArrayList<Integer>();
        Integer scopeType = dataScope.getScopeType();
        String scopeColumn = dataScope.getScopeColumn();
        DataScopeEnum dataScopeEnum = DataScopeEnum.of((Integer)scopeType);
        if (HussarUtils.isEmpty((Object)scopeColumn) || HussarUtils.isEmpty((Object)scopeType) || HussarUtils.isEmpty((Object)dataScopeEnum)) {
            return null;
        }
        scopeTypes.add(scopeType);
        dataScopeInfo.setScopeTypes(scopeTypes);
        if (dataScopeEnum == DataScopeEnum.OWN_DEPT_CHILD || dataScopeEnum == DataScopeEnum.OWN_DEPT) {
            List deptIds = this.dataScopeService.getDeptIds(scopeType, userId);
            dataScopeInfo.setScopeDeptIds(deptIds);
        }
        if (dataScopeEnum == DataScopeEnum.OWN) {
            dataScopeInfo.setUserScopeField(dataScope.getScopeColumn());
        } else {
            dataScopeInfo.setDeptScopeField(dataScope.getScopeColumn());
        }
        return dataScopeInfo;
    }

    private String sqlPackage(Executor executor, Object parameter, UserDetails userDetails, DataScopeInfo dataScopeInfo, List<DataScopeInfo> customDataScopeInfos, String originalSql) {
        try {
            String finalDataScopeSql;
            String customOrSql;
            Select select = (Select)CCJSqlParserUtil.parse((String)originalSql);
            SelectBody selectBody = select.getSelectBody();
            if (selectBody instanceof SetOperationList) {
                log.warn("\u6570\u636e\u6743\u9650\u4e0d\u652f\u6301UNION\u67e5\u8be2");
                String string = null;
                return string;
            }
            PlainSelect plainSelect = (PlainSelect)selectBody;
            String dataScopeSql = this.resolveDataScope(userDetails, dataScopeInfo);
            CustomSqlCondition customSqlCondition = this.resolveCustomDataScope(customDataScopeInfos, originalSql);
            String customAndSql = HussarUtils.isNotEmpty((Object)customSqlCondition) ? customSqlCondition.getAndSqlCondition() : "";
            String string = customOrSql = HussarUtils.isNotEmpty((Object)customSqlCondition) ? customSqlCondition.getOrSqlCondition() : "";
            String string2 = ObjectUtil.isAllNotEmpty((Object[])new Object[]{dataScopeSql, customOrSql}) ? "(" + dataScopeSql + " OR " + customOrSql + ")" : (finalDataScopeSql = ObjectUtil.isNotEmpty((Object)dataScopeSql) ? dataScopeSql : customOrSql);
            String string3 = ObjectUtil.isAllNotEmpty((Object[])new Object[]{finalDataScopeSql, customAndSql}) ? "(" + finalDataScopeSql + "AND" + customAndSql + ")" : (finalDataScopeSql = ObjectUtil.isNotEmpty((Object)finalDataScopeSql) ? finalDataScopeSql : customAndSql);
            if (ObjectUtil.isEmpty((Object)finalDataScopeSql)) {
                String string4 = null;
                return string4;
            }
            Expression where = plainSelect.getWhere();
            boolean hasWhere = HussarUtils.isNotEmpty((Object)where);
            Expression dataScopeExpression = CCJSqlParserUtil.parseCondExpression((String)finalDataScopeSql);
            if (hasWhere) {
                Parenthesis parenthesis = new Parenthesis(where);
                AndExpression andExpression = new AndExpression();
                andExpression.setLeftExpression((Expression)parenthesis);
                andExpression.setRightExpression(dataScopeExpression);
                plainSelect.setWhere((Expression)andExpression);
            } else {
                plainSelect.setWhere(dataScopeExpression);
            }
            String string5 = select.toString();
            return string5;
        }
        catch (JSQLParserException e) {
            throw new DataScopeException("SQL\u89e3\u6790\u5931\u8d25");
        }
        finally {
            CustomDataScopeTableInfoCache.remove();
        }
    }

    private String resolveDataScope(UserDetails userDetails, DataScopeInfo dataScopeInfo) {
        if (HussarUtils.isEmpty((Object)dataScopeInfo)) {
            return null;
        }
        List scopeTypes = dataScopeInfo.getScopeTypes();
        if (HussarUtils.isEmpty((Object)scopeTypes)) {
            return null;
        }
        Integer finalType = null;
        for (Integer scopeType : scopeTypes) {
            if (HussarUtils.isEmpty((Object)scopeType)) continue;
            if (HussarUtils.isEmpty(finalType)) {
                finalType = scopeType;
            }
            if (scopeType > finalType) continue;
            finalType = scopeType;
        }
        DataScopeEnum finalScope = DataScopeEnum.of(finalType);
        if (HussarUtils.isEmpty((Object)finalScope) || DataScopeEnum.ALL == finalScope || DataScopeEnum.USER_EXTEND == finalScope) {
            return null;
        }
        Expression expression = DataScopeEnum.OWN == finalScope ? this.ownSql(userDetails.getUserId(), dataScopeInfo) : this.deptSql(dataScopeInfo);
        return expression == null ? "" : expression.toString();
    }

    private CustomSqlCondition resolveCustomDataScope(List<DataScopeInfo> customDataScopeInfos, String originalSql) {
        return this.dataScopeService.getCustomSqlCondition(customDataScopeInfos, originalSql);
    }

    private Expression deptSql(DataScopeInfo dataScopeInfo) {
        List deptIds = dataScopeInfo.getScopeDeptIds();
        String deptScopeField = dataScopeInfo.getDeptScopeField();
        if (HussarUtils.isNotEmpty((Object)deptIds) && HussarUtils.isNotEmpty((Object)deptScopeField)) {
            Parenthesis parenthesis = new Parenthesis();
            InExpression inExpression = new InExpression();
            inExpression.setLeftExpression((Expression)this.getColumn(deptScopeField));
            ExpressionList expressionList = new ExpressionList();
            for (Long deptId : deptIds) {
                LongValue longValue = new LongValue(deptId.longValue());
                expressionList.addExpressions(new Expression[]{longValue});
            }
            inExpression.setRightItemsList((ItemsList)expressionList);
            parenthesis.setExpression((Expression)inExpression);
            return parenthesis;
        }
        return null;
    }

    private Expression ownSql(Long id, DataScopeInfo dataScopeInfo) {
        String userScopeField = dataScopeInfo.getUserScopeField();
        if (HussarUtils.isEmpty((Object)id) || HussarUtils.isEmpty((Object)userScopeField)) {
            return null;
        }
        Parenthesis parenthesis = new Parenthesis();
        EqualsTo equalTo = new EqualsTo();
        Column column = this.getColumn(userScopeField);
        equalTo.setLeftExpression((Expression)column);
        equalTo.setRightExpression((Expression)new LongValue(id.longValue()));
        Expression deptSql = this.deptSql(dataScopeInfo);
        if (HussarUtils.isNotEmpty((Object)deptSql)) {
            OrExpression orExpression = new OrExpression();
            orExpression.setLeftExpression((Expression)equalTo);
            orExpression.setRightExpression(deptSql);
            parenthesis.setExpression((Expression)orExpression);
        } else {
            parenthesis.setExpression((Expression)equalTo);
        }
        return parenthesis;
    }

    private Column getColumn(String scopeFiled) {
        Column column = new Column();
        if (!scopeFiled.contains(".")) {
            column.setColumnName(scopeFiled);
        } else {
            String[] tableAndColumn = scopeFiled.split("\\.");
            Table table = new Table(tableAndColumn[0]);
            column.setTable(table);
            column.setColumnName(tableAndColumn[1]);
        }
        return column;
    }
}

