/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.feign;

import com.jxdinfo.hussar.support.config.manager.api.HussarConfigApi;
import com.jxdinfo.hussar.support.config.manager.dto.SaveConfigGroupDto;
import com.jxdinfo.hussar.support.config.manager.dto.SaveConfigInfoDto;
import com.jxdinfo.hussar.support.config.manager.dto.UpdateConfigGroupDto;
import com.jxdinfo.hussar.support.config.manager.dto.UpdateConfigInfoDto;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigInfoEntity;
import com.jxdinfo.hussar.support.config.manager.vo.ConfigValueVo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/support/config/api"})
public class FeignHussarConfigApiController {
    @Autowired
    private HussarConfigApi hussarConfigApi;

    @PostMapping(value={"/saveConfigGroup"})
    public void saveConfigGroup(@RequestBody SaveConfigGroupDto configGroupDto) {
        this.hussarConfigApi.saveConfigGroup(configGroupDto);
    }

    @PostMapping(value={"/updateConfigGroup"})
    public void updateConfigGroup(@RequestBody UpdateConfigGroupDto configGroupDto) {
        this.hussarConfigApi.updateConfigGroup(configGroupDto);
    }

    @PostMapping(value={"/saveConfigInfo"})
    public void saveConfigInfo(@RequestBody SaveConfigInfoDto configInfoDto) {
        this.hussarConfigApi.saveConfigInfo(configInfoDto);
    }

    @PostMapping(value={"/updateConfigInfo"})
    public void updateConfigInfo(@RequestBody UpdateConfigInfoDto configInfoDto) {
        this.hussarConfigApi.updateConfigInfo(configInfoDto);
    }

    @GetMapping(value={"/getConfigInfo"})
    public ConfigInfoEntity getConfigInfo(String configKey) {
        ConfigInfoEntity configInfo = this.hussarConfigApi.getConfigInfo(configKey);
        return configInfo;
    }

    @GetMapping(value={"/getConfigByGroupPath"})
    public List<ConfigValueVo> getConfigByGroupPath(String groupPath) {
        List configByGroupPath = this.hussarConfigApi.getConfigByGroupPath(groupPath);
        return configByGroupPath;
    }

    @GetMapping(value={"/getConfigInfoString"})
    public String getConfigInfoString(String configKey) {
        String configInfoString = this.hussarConfigApi.getConfigInfoString(configKey);
        return configInfoString;
    }

    @GetMapping(value={"/getConfigInfoBoolean"})
    public Boolean getConfigInfoBoolean(String configKey) {
        Boolean configInfoBoolean = this.hussarConfigApi.getConfigInfoBoolean(configKey);
        return configInfoBoolean;
    }

    @GetMapping(value={"/getConfigInfoInteger"})
    public Integer getConfigInfoInteger(String configKey) {
        Integer configInfoInteger = this.hussarConfigApi.getConfigInfoInteger(configKey);
        return configInfoInteger;
    }
}

