/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.config.manager.core.dto.ConfigInfoDto;
import com.jxdinfo.hussar.support.config.manager.core.service.HussarConfigInfoService;
import com.jxdinfo.hussar.support.config.manager.core.vo.ConfigInfoVo;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigInfoEntity;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.api.impl.ConfigGetApiImpl;
import com.jxdinfo.hussar.support.config.manager.vo.ConfigValueVo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/support/config/info"})
public class ConfigInfoController {
    private static final Logger log = LoggerFactory.getLogger(ConfigInfoController.class);
    @Autowired
    private HussarConfigInfoService hussarConfiginfoService;
    @Autowired
    private ConfigGetApiImpl configGetApi;

    @PostMapping(value={"/save"})
    public ApiResponse saveConfigInfo(@RequestBody ConfigInfoDto configInfoDto) {
        this.hussarConfiginfoService.saveConfigInfo(configInfoDto);
        return ApiResponse.success((String)"\u914d\u7f6e\u4fe1\u606f\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/update"})
    public ApiResponse updateConfigInfo(@RequestBody ConfigInfoDto configInfoDto) {
        this.hussarConfiginfoService.updateConfigInfo(configInfoDto);
        return ApiResponse.success((String)"\u914d\u7f6e\u4fe1\u606f\u4fee\u6539\u6210\u529f");
    }

    @GetMapping(value={"/delete"})
    public ApiResponse deleteConfigInfo(Long id) {
        this.hussarConfiginfoService.deleteConfigInfo(id);
        return ApiResponse.success((String)"\u914d\u7f6e\u4fe1\u606f\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/detail"})
    public ApiResponse<ConfigInfoVo> detailConfigInfo(@RequestParam(value="id") Long configId) {
        ConfigInfoVo configGroupVo = this.hussarConfiginfoService.getConfigInfoById(configId);
        return ApiResponse.success((Object)configGroupVo);
    }

    @GetMapping(value={"/getPageList"})
    public ApiResponse<IPage<ConfigInfoEntity>> getPageList(Page<ConfigInfoEntity> page, ConfigInfoDto configInfoDto, HttpServletRequest request) {
        IPage configInfoEntityIPage = this.hussarConfiginfoService.listPage(configInfoDto, page, request);
        return ApiResponse.success((Object)configInfoEntityIPage);
    }

    @GetMapping(value={"/list"})
    public ApiResponse<List<ConfigInfoEntity>> list(ConfigInfoDto configInfoDto, HttpServletRequest request) {
        List configInfoEntityIPage = this.hussarConfiginfoService.list(configInfoDto, request);
        return ApiResponse.success((Object)configInfoEntityIPage);
    }

    @GetMapping(value={"/getConfigInfoByGroupPath"})
    public ApiResponse<List<ConfigValueVo>> getConfigInfoByGroupPath(@RequestParam(value="groupPath", required=false) String groupPath) {
        List configInfoEntityList = this.hussarConfiginfoService.getConfigByGroupPath(groupPath);
        return ApiResponse.success((Object)configInfoEntityList);
    }

    @GetMapping(value={"/getConfigByKey"})
    public ApiResponse<ConfigInfoEntity> getConfigByKey(@RequestParam(value="configKey") String configKey) {
        ConfigInfoEntity configInfo = this.configGetApi.getConfigInfo(configKey);
        return ApiResponse.success((Object)configInfo);
    }
}

