/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.config.manager.core.dto.ConfigGroupDto;
import com.jxdinfo.hussar.support.config.manager.core.service.HussarConfigGroupService;
import com.jxdinfo.hussar.support.config.manager.core.vo.ConfigGroupVo;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigGroupEntity;
import com.jxdinfo.hussar.support.config.manager.vo.ConfigAndGroupVo;
import com.jxdinfo.hussar.support.config.manager.vo.ConfigGroupAndInfoTreeVo;
import com.jxdinfo.hussar.support.config.manager.vo.ConfigGroupTreeVo;
import com.jxdinfo.hussar.support.config.manager.vo.configGroupAndParentNameVo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/support/config/group"})
public class ConfigGroupController {
    @Autowired
    private HussarConfigGroupService hussarConfigGroupService;

    @PostMapping(value={"/save"})
    public ApiResponse saveConfigGroup(@RequestBody ConfigGroupDto configGroupDto) {
        this.hussarConfigGroupService.saveConfigGroup(configGroupDto);
        return ApiResponse.success((String)"\u914d\u7f6e\u5206\u7ec4\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/update"})
    public ApiResponse updateConfigGroup(@RequestBody ConfigGroupDto configGroupDto) {
        this.hussarConfigGroupService.updateConfigGroup(configGroupDto);
        return ApiResponse.success((String)"\u914d\u7f6e\u5206\u7ec4\u4fee\u6539\u6210\u529f");
    }

    @GetMapping(value={"/delete"})
    public ApiResponse deleteConfigGroup(Long id) {
        this.hussarConfigGroupService.deleteConfigGroup(id);
        return ApiResponse.success((String)"\u914d\u7f6e\u5206\u7ec4\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/detail"})
    public ApiResponse<ConfigGroupVo> detailConfigGroup(@RequestParam(value="id") Long configGroupId) {
        ConfigGroupVo configGroupVo = this.hussarConfigGroupService.getConfigGroupById(configGroupId);
        return ApiResponse.success((Object)configGroupVo);
    }

    @GetMapping(value={"/getPageList"})
    public ApiResponse<IPage<ConfigGroupEntity>> getPageList(Page<ConfigGroupEntity> page, ConfigGroupDto configGroupDto, HttpServletRequest request) {
        IPage configGroupEntityIPage = this.hussarConfigGroupService.listPage(configGroupDto, page, request);
        return ApiResponse.success((Object)configGroupEntityIPage);
    }

    @GetMapping(value={"/list"})
    public ApiResponse<List<ConfigGroupEntity>> list(ConfigGroupDto configGroupDto, HttpServletRequest request) {
        List configGroupEntityList = this.hussarConfigGroupService.list(configGroupDto, request);
        return ApiResponse.success((Object)configGroupEntityList);
    }

    @GetMapping(value={"/lazyLoadGroupTree"})
    public ApiResponse<List<ConfigGroupTreeVo>> lazyLoadGroupTree(@RequestParam(value="parentId") Long parentId) {
        List groupTreeVos = this.hussarConfigGroupService.lazyLoadGroupTree(parentId);
        return ApiResponse.success((Object)groupTreeVos);
    }

    @GetMapping(value={"/lazyLoadGroupAndInfoTree"})
    public ApiResponse<List<ConfigGroupAndInfoTreeVo>> lazyLoadGroupAndInfoTree(@RequestParam(value="parentId") Long parentId) {
        List groupTreeVos = this.hussarConfigGroupService.lazyLoadGroupAndInfoTree(parentId);
        return ApiResponse.success((Object)groupTreeVos);
    }

    @GetMapping(value={"/lazyGroupTreeSearchBar"})
    public ApiResponse<List<configGroupAndParentNameVo>> lazyGroupTreeSearchBar(@RequestParam(value="groupName_list") String groupName) {
        List configGroupAndParentNameVoList = this.hussarConfigGroupService.listGroupByName(groupName);
        return ApiResponse.success((Object)configGroupAndParentNameVoList);
    }

    @GetMapping(value={"/listGroupAndInfoByName"})
    public ApiResponse<ConfigAndGroupVo> listGroupAndInfoByName(@RequestParam(value="name") String name) {
        ConfigAndGroupVo configGroupAndParentNameVoList = this.hussarConfigGroupService.listGroupAndInfoByName(name);
        return ApiResponse.success((Object)configGroupAndParentNameVoList);
    }

    @GetMapping(value={"/backGroupTree"})
    public ApiResponse<List<ConfigGroupTreeVo>> backGroupTree(@RequestParam(value="groupId") Long groupId) {
        List groupTreeVos = this.hussarConfigGroupService.backGroupTree(groupId);
        return ApiResponse.success((Object)groupTreeVos);
    }
}

