/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.jxdinfo.hussar.platform.core.config.HussarCoreProperties;
import com.jxdinfo.hussar.platform.core.tenant.util.HussarTenantContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeColumnData;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeRowData;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigInfoEntity;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.AbstractDataChangeListener;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.utils.HussarConfigInfoUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

public class ConfigDataChangeListener
extends AbstractDataChangeListener
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ConfigDataChangeListener.class);
    private ApplicationContext applicationContext;

    public ConfigDataChangeListener(HussarCoreProperties hussarCoreProperties) {
        super(hussarCoreProperties);
    }

    @Override
    public void doDataChange(TableInfo tableInfo, List<ChangeRowData> changeRowDataList) {
        boolean refresh = false;
        ArrayList<ConfigInfoEntity> changeInfos = new ArrayList<ConfigInfoEntity>();
        ArrayList<ConfigInfoEntity> delInfos = new ArrayList<ConfigInfoEntity>();
        TableFieldInfo configKeyField = HussarConfigInfoUtils.getTableFieldInfo(tableInfo, "configKey");
        TableFieldInfo configValueField = HussarConfigInfoUtils.getTableFieldInfo(tableInfo, "configValue");
        TableFieldInfo valueTypeField = HussarConfigInfoUtils.getTableFieldInfo(tableInfo, "valueType");
        if (configValueField == null || valueTypeField == null || configKeyField == null) {
            return;
        }
        for (ChangeRowData changeRowData : changeRowDataList) {
            Map changeColumnMap = changeRowData.getChangeColumnMap();
            if (!changeColumnMap.containsKey(configKeyField.getColumn()) && !changeColumnMap.containsKey(configValueField.getColumn()) && !changeColumnMap.containsKey(valueTypeField.getColumn())) continue;
            refresh = true;
            if (HussarUtils.isNotEmpty((Object)changeRowData.getAfterColumnList())) {
                changeInfos.add(this.getConfigInfo(tableInfo, changeRowData.getAfterColumnList()));
                continue;
            }
            if (!HussarUtils.isNotEmpty((Object)changeRowData.getBeforeColumnList())) continue;
            delInfos.add(this.getConfigInfo(tableInfo, changeRowData.getBeforeColumnList()));
        }
        if (refresh) {
            if (HussarUtils.isNotEmpty(changeInfos)) {
                log.info("\u914d\u7f6e\u4e2d\u5fc3\u66f4\u65b0\u4e86\u5982\u4e0b\u6570\u636e {}", (Object)JSON.toJSONString(changeInfos));
                HussarFixedCacheUtil.put((String)"hussar_config", (Object)"refresh_change_data", changeInfos);
            }
            if (HussarUtils.isNotEmpty(delInfos)) {
                log.info("\u914d\u7f6e\u4e2d\u5fc3\u5220\u9664\u4e86\u5982\u4e0b\u6570\u636e {}", (Object)JSON.toJSONString(delInfos));
            }
            HussarFixedCacheUtil.evict((String)"hussar_config", (Object)"refresh_cache");
            this.applicationContext.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, null, "Refresh hussar Config"));
        }
    }

    private ConfigInfoEntity getConfigInfo(TableInfo tableInfo, List<ChangeColumnData> afterColumnList) {
        Map<String, Object> colum2Value = afterColumnList.stream().collect(Collectors.toMap(ChangeColumnData::getName, ChangeColumnData::getValue));
        Map<String, String> column2Field = tableInfo.getFieldList().stream().collect(Collectors.toMap(TableFieldInfo::getColumn, e -> e.getField().getName()));
        HashMap<String, Object> field2Value = new HashMap<String, Object>();
        for (String column : colum2Value.keySet()) {
            field2Value.put(column2Field.get(column), colum2Value.get(column));
        }
        ConfigInfoEntity configInfoEntity = (ConfigInfoEntity)JSON.parseObject((String)JSON.toJSONString(field2Value), ConfigInfoEntity.class);
        configInfoEntity.setTenantCode(HussarTenantContextHolder.getTenant().getTenantCode());
        return configInfoEntity;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

