/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.loader.client.redis;

import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.config.HussarRedisAutoConfiguration;
import com.jxdinfo.hussar.support.cache.support.CacheNameCreator;
import com.jxdinfo.hussar.support.cache.support.HussarCache;
import com.jxdinfo.hussar.support.cache.support.NoCacheManagerException;
import com.jxdinfo.hussar.support.cache.support.properties.HussarCacheProperties;
import com.jxdinfo.hussar.support.cache.support.properties.HussarSecurityProperties;
import com.jxdinfo.hussar.support.cache.support.redis.HussarSpringRedisCacheManger;
import com.jxdinfo.hussar.support.cache.support.redis.HussarSpringRedisCacheWriter;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.loader.client.redis.RedisClient;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.utils.HussarConfigInfoUtils;
import io.lettuce.core.resource.ClientResources;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class DefaultRedisClient
implements RedisClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultRedisClient.class);
    private HussarCacheProperties hussarCacheProperties;
    private RedisProperties redisProperties;
    private HussarTenantProperties hussarTenantProperties;
    private HussarSecurityProperties hussarSecurityProperties;
    private HussarRedisAutoConfiguration hussarRedisAutoConfiguration;
    private RedisSerializer<String> stringRedisSerializer;
    private RedisSerializer jackson2JsonRedisSerializer;
    private HussarSpringRedisCacheWriter hussarSpringRedisCacheWriter;
    private CacheNameCreator cacheNameCreator;
    private RedisTemplate<String, Object> redisTemplate;
    private HussarSpringRedisCacheManger cacheManager;
    private static volatile DefaultRedisClient defaultRedisClient;
    private LettuceConnectionFactory lettuceConnectionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultRedisClient getInstance(ConfigurableEnvironment environment) {
        if (defaultRedisClient != null) return defaultRedisClient;
        Class<DefaultRedisClient> clazz = DefaultRedisClient.class;
        synchronized (DefaultRedisClient.class) {
            if (defaultRedisClient != null) return defaultRedisClient;
            defaultRedisClient = new DefaultRedisClient(environment);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultRedisClient;
        }
    }

    private DefaultRedisClient(ConfigurableEnvironment environment) {
        this.hussarCacheProperties = HussarConfigInfoUtils.buildHussarCacheProperties(environment);
        this.redisProperties = HussarConfigInfoUtils.buildRedisProperties(environment);
        this.hussarTenantProperties = HussarConfigInfoUtils.buildProperties(environment, new HussarTenantProperties(), "hussar.core.tenant");
        this.hussarSecurityProperties = HussarConfigInfoUtils.buildProperties(environment, new HussarSecurityProperties(), "hussar.security");
        this.init();
    }

    private void init() {
        log.info("\u914d\u7f6e\u4e2d\u5fc3\u521d\u59cb\u5316redis\u5ba2\u6237\u7aef..............");
        log.info("\u914d\u7f6e\u4e2d\u5fc3\u914d\u7f6e\u7684Redis\u4fe1\u606f [host=" + this.redisProperties.getHost() + "],[url=" + this.redisProperties.getPort() + "],[database=" + this.redisProperties.getDatabase() + "]");
        this.hussarRedisAutoConfiguration = new HussarRedisAutoConfiguration(this.hussarCacheProperties);
        this.stringRedisSerializer = this.hussarRedisAutoConfiguration.stringRedisSerializer();
        this.jackson2JsonRedisSerializer = this.hussarRedisAutoConfiguration.jackson2JsonRedisSerializer();
        this.lettuceConnectionFactory = this.hussarRedisAutoConfiguration.lettuceConnectionFactory((ClientResources)this.hussarRedisAutoConfiguration.lettuceClientResources(), this.redisProperties);
        this.lettuceConnectionFactory.afterPropertiesSet();
        this.hussarSpringRedisCacheWriter = this.hussarRedisAutoConfiguration.hussarSpringRedisCacheWriter(this.lettuceConnectionFactory);
        this.cacheNameCreator = this.hussarRedisAutoConfiguration.cacheNameCreator();
        this.redisTemplate = this.createRedisTemplate();
        this.cacheManager = this.hussarRedisAutoConfiguration.cacheManager(this.hussarSpringRedisCacheWriter, this.hussarTenantProperties, this.hussarSecurityProperties, this.hussarCacheProperties, this.cacheNameCreator);
    }

    private RedisTemplate<String, Object> createRedisTemplate() {
        if (HussarUtils.isEmpty((Object)this.lettuceConnectionFactory)) {
            return null;
        }
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory((RedisConnectionFactory)this.lettuceConnectionFactory);
        template.setKeySerializer(this.stringRedisSerializer);
        template.setHashKeySerializer(this.stringRedisSerializer);
        template.setValueSerializer(this.jackson2JsonRedisSerializer);
        template.setHashValueSerializer(this.jackson2JsonRedisSerializer);
        template.afterPropertiesSet();
        return template;
    }

    private HussarCache getCache(String cacheName) {
        if (StringUtils.isEmpty((Object)cacheName)) {
            throw new NoCacheManagerException("\u7f13\u5b58\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return (HussarCache)this.cacheManager.getCache(cacheName);
    }

    @Override
    public <T> T get(String cacheName, Object key, @Nullable Class<T> type) {
        Object t = null;
        try {
            t = this.getCache(cacheName).get(key, type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)t;
    }

    @Override
    public void put(String cacheName, String key, Object value) {
        Long keyExpireTime = this.getCache(cacheName).getKeyExpireTime((Object)key);
        if (HussarUtils.isEmpty((Object)keyExpireTime)) {
            this.getCache(cacheName).put((Object)key, value, Duration.ZERO);
        } else {
            this.getCache(cacheName).put((Object)key, value, keyExpireTime.longValue());
        }
    }

    @Override
    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    @Override
    public HussarSpringRedisCacheManger getCacheManager() {
        return this.cacheManager;
    }
}

