/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.loader.client.jdbc;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.config.manager.core.properties.DataBaseConfig;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.loader.client.jdbc.JdbcClient;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.loader.client.redis.DefaultRedisClient;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.utils.CryptoUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DefaultJdbcClient
implements JdbcClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultJdbcClient.class);
    private static final Pattern ENC_PATTERN = Pattern.compile("^ENC\\((.*)\\)$");
    private static volatile DefaultJdbcClient defaultJdbcClient;
    private DataBaseConfig dataBaseConfig;
    Connection conn = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultJdbcClient getInstance(DataBaseConfig datasource) {
        if (defaultJdbcClient != null) return defaultJdbcClient;
        Class<DefaultRedisClient> clazz = DefaultRedisClient.class;
        synchronized (DefaultRedisClient.class) {
            if (defaultJdbcClient != null) return defaultJdbcClient;
            defaultJdbcClient = new DefaultJdbcClient(datasource);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultJdbcClient;
        }
    }

    private DefaultJdbcClient(DataBaseConfig dataBaseConfig) {
        this.dataBaseConfig = dataBaseConfig;
        this.init();
    }

    private void init() {
        try {
            String driverClassName = this.dataBaseConfig.getDriverClassName();
            String url = this.dataBaseConfig.getUrl();
            String username = this.dataBaseConfig.getUsername();
            String password = this.dataBaseConfig.getPassword();
            String publicKey = this.dataBaseConfig.getPublicKey();
            log.info("\u914d\u7f6e\u4e2d\u5fc3\u914d\u7f6e\u7684\u6570\u636e\u5e93\u4fe1\u606f[driverClass=" + driverClassName + "],[url=" + url + "],[username=" + username + "]");
            if (!StringUtils.isEmpty((Object)driverClassName)) {
                Class.forName(driverClassName);
                log.info("\u914d\u7f6e\u4e2d\u5fc3\u6210\u529f\u52a0\u8f7d\u6570\u636e\u5e93\u9a71\u52a8\u7a0b\u5e8f\uff1a" + driverClassName);
            }
            if (HussarUtils.isNotEmpty((Object)publicKey)) {
                url = this.decrypt(publicKey, url);
                password = this.decrypt(publicKey, password);
                username = this.decrypt(publicKey, username);
            }
            this.conn = DriverManager.getConnection(url, username, password);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private String decrypt(String publicKey, String cipherText) {
        Matcher matcher;
        if (StringUtils.hasText((String)cipherText) && (matcher = ENC_PATTERN.matcher(cipherText)).find()) {
            try {
                return CryptoUtils.decrypt(publicKey, matcher.group(1));
            }
            catch (Exception e) {
                log.error("master dataSource decrypt error ", (Throwable)e);
            }
        }
        return cipherText;
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }
}

