/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.loader.boot;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.config.manager.core.properties.ConfigProperties;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigInfoEntity;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.loader.boot.AbstractJdbcConfigInfoLoaderHandler;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.utils.HussarConfigInfoUtils;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;

public class LocalJdbcConfigInfoLoaderHandler
extends AbstractJdbcConfigInfoLoaderHandler {
    private static final Logger log = LoggerFactory.getLogger(LocalJdbcConfigInfoLoaderHandler.class);

    @Override
    protected List<ConfigInfoEntity> executeStmt(Statement statement, ConfigProperties configProperties) throws SQLException {
        String selectConfigInfoSql = configProperties.getSelectConfigInfoSql();
        log.info("\u83b7\u53d6\u914d\u7f6e\u4e2d\u5fc3\u7684sql\u4e3a:[{}]", (Object)selectConfigInfoSql);
        ResultSet rs = statement.executeQuery(selectConfigInfoSql);
        ArrayList<ConfigInfoEntity> configInfoEntityList = new ArrayList<ConfigInfoEntity>();
        while (rs.next()) {
            ResultSetMetaData metaData = rs.getMetaData();
            if (HussarUtils.isEmpty((Object)metaData) || metaData.getColumnCount() <= 0) {
                return configInfoEntityList;
            }
            HashMap<String, Object> resultEntityMap = new HashMap<String, Object>();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                resultEntityMap.put(metaData.getColumnLabel(i), rs.getObject(metaData.getColumnLabel(i)));
            }
            ConfigInfoEntity configInfoEntity = HussarConfigInfoUtils.mapToBeanWithNoCase(resultEntityMap, ConfigInfoEntity.class);
            if (!HussarUtils.isNotEmpty((Object)configInfoEntity) || !HussarUtils.isNotEmpty((Object)configInfoEntity.getConfigKey()) || !HussarUtils.isNotEmpty((Object)configInfoEntity.getConfigValue())) continue;
            configInfoEntityList.add(configInfoEntity);
        }
        return configInfoEntityList;
    }

    @Override
    public boolean support(ConfigurableEnvironment configurableEnvironment) {
        return HussarConfigInfoUtils.isConfigServerPresent();
    }
}

