/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.api.impl;

import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.ClassUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.convert.ConverterRegistry;
import com.jxdinfo.hussar.support.config.manager.core.service.CustomPropertySource;
import com.jxdinfo.hussar.support.config.manager.core.support.refresh.propertysource.ConfigInfoProperty;
import com.jxdinfo.hussar.support.config.manager.core.support.service.ConfigGetApi;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigInfoEntity;
import com.jxdinfo.hussar.support.exception.HussarException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigGetApiImpl
implements ConfigGetApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigGetApiImpl.class);
    @Autowired
    private CustomPropertySource customPropertySource;

    public <T> T getConfigInfo(Class<T> clz, String configKey) {
        ConfigInfoEntity configInfoEntity = this.getConfigInfo(configKey);
        return this.convertValue(clz, configInfoEntity);
    }

    public ConfigInfoEntity getConfigInfo(String configKey) {
        ConfigInfoProperty property = this.customPropertySource.getConfigInfoProperty(configKey);
        return (ConfigInfoEntity)BeanUtil.copyProperties((Object)property, ConfigInfoEntity.class);
    }

    private <T> T convertValue(Class<T> clz, ConfigInfoEntity configInfoEntity) {
        if (HussarUtils.isEmpty((Object)configInfoEntity) || HussarUtils.isEmpty((Object)configInfoEntity.getConfigValue())) {
            return null;
        }
        String configKey = configInfoEntity.getConfigKey();
        String configValue = configInfoEntity.getConfigValue();
        String valueType = configInfoEntity.getValueType();
        HussarException.throwBy((!ClassUtil.equals(clz, (String)configInfoEntity.getValueType(), (boolean)true) ? 1 : 0) != 0, (String)("configKey{" + configKey + "}\u5b9a\u4e49\u7684\u503c\u7c7b\u578b{" + valueType + "},\u4e0e\u8bd5\u56fe\u83b7\u53d6\u7684{" + clz.getSimpleName() + "}\u7c7b\u578b\u4e0d\u5339\u914d"));
        Object convert = null;
        try {
            ConverterRegistry instance = ConverterRegistry.getInstance();
            convert = instance.convert(clz, (Object)configValue);
        }
        catch (Exception e) {
            throw new HussarException("\u6839\u636econfigKey{" + configKey + "},\u83b7\u53d6\u7684\u503c{" + configValue + "},\u8f6c\u5316\u6210{" + clz.getSimpleName() + "}\uff0c\u5931\u8d25", (Throwable)e);
        }
        return (T)convert;
    }
}

