/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.plugin.refresh.utils;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.jxdinfo.hussar.platform.core.config.HussarCoreProperties;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.ReflectUtil;
import com.jxdinfo.hussar.support.cache.support.properties.HussarCacheProperties;
import com.jxdinfo.hussar.support.config.manager.core.properties.ConfigProperties;
import com.jxdinfo.hussar.support.config.manager.core.properties.DataBaseConfig;
import com.jxdinfo.hussar.support.config.manager.core.support.anno.ConfigKeyChange;
import com.jxdinfo.hussar.support.config.manager.core.support.listener.ConfigChangeData;
import com.jxdinfo.hussar.support.config.manager.core.support.listener.ConfigKeyListener;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.properties.DatasourceProperties;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.loader.AbstractConfigInfoLoaderHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;

public class HussarConfigInfoUtils {
    private static final Logger logger = LoggerFactory.getLogger(HussarConfigInfoUtils.class);
    private static String METHOD_NAME = "onKeyChange";
    public static final String CONFIG_MYBATIS_CONFIGURATION_PACKAGE = "com.jxdinfo.hussar.config.manager.plugin.mybatis.config.ConfigMybatisConfiguration";

    public static ConfigProperties buildConfigProperties(ConfigurableEnvironment environment) {
        DatasourceProperties datasourceProperties;
        ConfigProperties configProperties = new ConfigProperties();
        if ((HussarUtils.isEmpty((Object)(configProperties = HussarConfigInfoUtils.buildProperties(environment, configProperties, "hussar.config"))) || HussarUtils.isEmpty((Object)configProperties.getDatasource()) || HussarUtils.isEmpty((Object)configProperties.getDatasource().getDriverClassName()) || HussarUtils.isEmpty((Object)configProperties.getDatasource().getUrl())) && (HussarUtils.isNotEmpty((Object)(datasourceProperties = HussarConfigInfoUtils.buildDatasourceProperties(environment))) || HussarUtils.isNotEmpty((Object)datasourceProperties.getDriverClassName()) || HussarUtils.isNotEmpty((Object)datasourceProperties.getUrl()))) {
            DataBaseConfig dataBaseConfig = new DataBaseConfig();
            dataBaseConfig.setPassword(datasourceProperties.getPassword());
            dataBaseConfig.setUrl(datasourceProperties.getUrl());
            dataBaseConfig.setUsername(datasourceProperties.getUsername());
            dataBaseConfig.setPublicKey(datasourceProperties.getPublicKey());
            dataBaseConfig.setDriverClassName(datasourceProperties.getDriverClassName());
            configProperties.setDatasource(dataBaseConfig);
        }
        return configProperties;
    }

    public static HussarCoreProperties buildHussarCoreProperties(ConfigurableEnvironment environment) {
        HussarCoreProperties hussarCoreProperties = new HussarCoreProperties();
        HussarConfigInfoUtils.buildProperties(environment, hussarCoreProperties, "hussar.core");
        return HussarConfigInfoUtils.buildProperties(environment, hussarCoreProperties, "hussar.core");
    }

    public static HussarCacheProperties buildHussarCacheProperties(ConfigurableEnvironment environment) {
        HussarCacheProperties hussarCacheProperties = new HussarCacheProperties();
        return HussarConfigInfoUtils.buildProperties(environment, hussarCacheProperties, "hussar.cache");
    }

    public static RedisProperties buildRedisProperties(ConfigurableEnvironment environment) {
        RedisProperties redisProperties = new RedisProperties();
        return HussarConfigInfoUtils.buildProperties(environment, redisProperties, "spring.redis");
    }

    public static DatasourceProperties buildDatasourceProperties(ConfigurableEnvironment environment) {
        DatasourceProperties datasourceProperties = new DatasourceProperties();
        return HussarConfigInfoUtils.buildProperties(environment, datasourceProperties, "spring.datasource.dynamic.datasource.master");
    }

    public static <T> T buildProperties(ConfigurableEnvironment environment, T properties, String prefix) {
        Binder binder = Binder.get((Environment)environment);
        ResolvableType type = ResolvableType.forClass(properties.getClass());
        Bindable target = Bindable.of((ResolvableType)type).withExistingValue(properties);
        binder.bind(prefix, target);
        return properties;
    }

    public static <T> T mapToBeanWithNoCase(Map<String, Object> beanMap, Class<T> valueType) {
        Object to = ReflectUtil.newInstance(valueType, (Object[])new Object[0]);
        if (beanMap.isEmpty()) {
            return (T)to;
        }
        Field[] fields = ReflectUtil.getFieldsDirectly(valueType, (boolean)true);
        for (Map.Entry<String, Object> entry : beanMap.entrySet()) {
            String mapKey = entry.getKey();
            for (Field prop : fields) {
                if (!HussarConfigInfoUtils.validateProp(mapKey, prop)) continue;
                BeanUtil.setProperty((Object)to, (String)prop.getName(), (Object)entry.getValue());
            }
        }
        return (T)to;
    }

    private static boolean validateProp(String columnName, Field prop) {
        TableField tableField;
        String propName = prop.getName();
        TableId tableId = prop.getAnnotation(TableId.class);
        if (HussarUtils.isNotEmpty((Object)tableId) && HussarUtils.isNotEmpty((Object)tableId.value())) {
            propName = tableId.value();
        }
        if (HussarUtils.isNotEmpty((Object)(tableField = prop.getAnnotation(TableField.class))) && HussarUtils.isNotEmpty((Object)tableField.value())) {
            propName = tableField.value();
        }
        return propName.equalsIgnoreCase(columnName);
    }

    public static Map<String, List<ConfigKeyListener>> doConfigKeyChangeListeners(List<ConfigKeyListener> configKeyChangeListeners) {
        HashMap<String, List<ConfigKeyListener>> map = new HashMap<String, List<ConfigKeyListener>>();
        for (ConfigKeyListener configKeyListener : configKeyChangeListeners) {
            String[] values;
            Method method = ReflectUtil.getMethod(configKeyListener.getClass(), (String)METHOD_NAME, (Class[])new Class[]{ConfigChangeData.class});
            ConfigKeyChange annotation = (ConfigKeyChange)AnnotationUtils.findAnnotation((Method)method, ConfigKeyChange.class);
            if (HussarUtils.isEmpty((Object)annotation) || HussarUtils.isEmpty((Object[])annotation.value())) continue;
            for (String v : values = annotation.value()) {
                if (map.containsKey(v)) {
                    ((List)map.get(v)).add(configKeyListener);
                    continue;
                }
                ArrayList<ConfigKeyListener> list = new ArrayList<ConfigKeyListener>();
                list.add(configKeyListener);
                map.put(v, list);
            }
        }
        return map;
    }

    public static TableFieldInfo getTableFieldInfo(TableInfo tableInfo, String propertyName) {
        Optional<TableFieldInfo> first = tableInfo.getFieldList().stream().filter(field -> field.getField().getName().equalsIgnoreCase(propertyName)).findFirst();
        if (!first.isPresent()) {
            return null;
        }
        return first.get();
    }

    public static boolean isConfigServerPresent() {
        return ClassUtils.isPresent((String)CONFIG_MYBATIS_CONFIGURATION_PACKAGE, (ClassLoader)AbstractConfigInfoLoaderHandler.class.getClassLoader());
    }
}

