/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.cloud;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.config.manager.core.support.listener.ConfigKeyListener;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.cloud.RedisConfigChangeMessage;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.keychange.ConfigKeyChangeData;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.keychange.ConfigKeyChangeHandler;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.keychange.DefaultConfigKeyChangeHandler;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.utils.HussarConfigInfoUtils;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisConfigChangeListener
implements MessageListener,
ApplicationContextAware {
    private RedisTemplate redisTemplate;
    private ApplicationContext applicationContext;
    private List<ConfigKeyListener> configKeyListenerList;
    private ConfigKeyChangeHandler configKeyChangeHandler;

    public RedisConfigChangeListener(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
        this.configKeyChangeHandler = new DefaultConfigKeyChangeHandler();
    }

    public RedisConfigChangeListener(RedisTemplate redisTemplate, List<ConfigKeyListener> configKeyListenerList) {
        this.redisTemplate = redisTemplate;
        this.configKeyListenerList = configKeyListenerList;
        this.configKeyChangeHandler = new DefaultConfigKeyChangeHandler();
    }

    public RedisConfigChangeListener(RedisTemplate redisTemplate, List<ConfigKeyListener> configKeyListenerList, ConfigKeyChangeHandler configKeyChangeHandler) {
        this.redisTemplate = redisTemplate;
        this.configKeyListenerList = configKeyListenerList;
        this.configKeyChangeHandler = configKeyChangeHandler;
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public List<ConfigKeyListener> getConfigKeyListenerList() {
        return this.configKeyListenerList;
    }

    public void setConfigKeyListenerList(List<ConfigKeyListener> configKeyListenerList) {
        this.configKeyListenerList = configKeyListenerList;
    }

    public void onMessage(Message message, byte[] pattern) {
        if (HussarConfigInfoUtils.isConfigServerPresent()) {
            return;
        }
        if (HussarUtils.isEmpty((Object)this.redisTemplate) || HussarUtils.isEmpty((Object)this.redisTemplate.getValueSerializer()) || HussarUtils.isEmpty((Object)message.getBody())) {
            return;
        }
        Object object = this.redisTemplate.getValueSerializer().deserialize(message.getBody());
        if (HussarUtils.isNotEmpty((Object)object) && object instanceof RedisConfigChangeMessage) {
            RedisConfigChangeMessage redisConfigChangeMessage = (RedisConfigChangeMessage)object;
            this.applicationContext.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, null, "Refresh hussaconfig"));
            this.configKeyChange(this.configKeyListenerList, redisConfigChangeMessage);
        }
    }

    private void configKeyChange(List<ConfigKeyListener> configKeyListenerList, RedisConfigChangeMessage redisConfigChangeMessage) {
        if (HussarUtils.isEmpty(configKeyListenerList) || HussarUtils.isEmpty((Object)redisConfigChangeMessage)) {
            return;
        }
        ConfigKeyChangeData configKeyChangeData = new ConfigKeyChangeData();
        configKeyChangeData.setChangeRowDataList(redisConfigChangeMessage.getChangeRowDataList());
        configKeyChangeData.setConfigInfoConfigKey(redisConfigChangeMessage.getConfigInfoConfigKey());
        configKeyChangeData.setConfigInfoConfigValue(redisConfigChangeMessage.getConfigInfoConfigValue());
        configKeyChangeData.setConfigKeyListenerList(configKeyListenerList);
        this.configKeyChangeHandler.doConfigKeyChange(configKeyChangeData);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

