/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.cloud;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.jxdinfo.hussar.platform.core.config.HussarCoreProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeRowData;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.config.manager.core.support.datamonitor.listener.AsyncDataChangeListener;
import com.jxdinfo.hussar.support.config.manager.core.support.listener.ConfigKeyListener;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigInfoEntity;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.cloud.ConfigChangeSender;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.cloud.RedisConfigChangeMessage;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.keychange.ConfigKeyChangeData;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.keychange.ConfigKeyChangeHandler;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.keychange.DefaultConfigKeyChangeHandler;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.utils.HussarConfigInfoUtils;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

public class CloudAsyncDataChangeListener
implements AsyncDataChangeListener,
ApplicationContextAware {
    private HussarCoreProperties hussarCoreProperties;
    private ConfigChangeSender redisConfigChangeSender;
    private ConfigKeyChangeHandler configKeyChangeHandler;
    private List<ConfigKeyListener> configKeyListenerList;
    private ApplicationContext applicationContext;

    public CloudAsyncDataChangeListener(ConfigChangeSender redisConfigChangeSender) {
        this.redisConfigChangeSender = redisConfigChangeSender;
        this.configKeyChangeHandler = new DefaultConfigKeyChangeHandler();
    }

    public CloudAsyncDataChangeListener(HussarCoreProperties hussarCoreProperties, ConfigChangeSender redisConfigChangeSender) {
        this.hussarCoreProperties = hussarCoreProperties;
        this.redisConfigChangeSender = redisConfigChangeSender;
        this.configKeyChangeHandler = new DefaultConfigKeyChangeHandler();
    }

    public CloudAsyncDataChangeListener(HussarCoreProperties hussarCoreProperties, ConfigChangeSender redisConfigChangeSender, List<ConfigKeyListener> configKeyListenerList) {
        this.hussarCoreProperties = hussarCoreProperties;
        this.redisConfigChangeSender = redisConfigChangeSender;
        this.configKeyListenerList = configKeyListenerList;
        this.configKeyChangeHandler = new DefaultConfigKeyChangeHandler();
    }

    public boolean isSupport(List<ChangeRowData> changeRowDataList) {
        if (HussarUtils.isEmpty(changeRowDataList)) {
            return false;
        }
        return this.hussarCoreProperties.isEnableMicroService();
    }

    public void dataChange(List<ChangeRowData> changeRowDataList) {
        if (HussarUtils.isEmpty(changeRowDataList)) {
            return;
        }
        ChangeRowData changeRowData = changeRowDataList.get(0);
        TableInfo tableInfo = TableInfoHelper.getTableInfo(ConfigInfoEntity.class);
        String tableName = tableInfo.getTableName();
        if (!changeRowData.getTableName().equalsIgnoreCase(tableName)) {
            return;
        }
        Optional<TableFieldInfo> first = tableInfo.getFieldList().stream().filter(field -> field.getField().getName().equalsIgnoreCase("configValue")).findFirst();
        if (!first.isPresent()) {
            return;
        }
        HussarFixedCacheUtil.evict((String)"hussar_config", (Object)"refresh_cache");
        TableFieldInfo valueTableField = HussarConfigInfoUtils.getTableFieldInfo(tableInfo, "configValue");
        TableFieldInfo keyTableField = HussarConfigInfoUtils.getTableFieldInfo(tableInfo, "configKey");
        RedisConfigChangeMessage redisConfigChangeMessage = new RedisConfigChangeMessage();
        redisConfigChangeMessage.setChangeRowDataList(changeRowDataList);
        redisConfigChangeMessage.setConfigInfoConfigKey(keyTableField.getColumn());
        redisConfigChangeMessage.setConfigInfoConfigValue(valueTableField.getColumn());
        this.applicationContext.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, null, "Refresh hussaconfig"));
        ConfigKeyChangeData configKeyChangeData = new ConfigKeyChangeData();
        configKeyChangeData.setChangeRowDataList(changeRowDataList);
        configKeyChangeData.setConfigKeyListenerList(this.configKeyListenerList);
        configKeyChangeData.setConfigInfoConfigKey(keyTableField.getColumn());
        configKeyChangeData.setConfigInfoConfigValue(valueTableField.getColumn());
        this.configKeyChangeHandler.doConfigKeyChange(configKeyChangeData);
        this.redisConfigChangeSender.sendMesaage(redisConfigChangeMessage);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

