/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.jxdinfo.hussar.platform.core.config.HussarCoreProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeRowData;
import com.jxdinfo.hussar.support.config.manager.core.support.listener.ConfigKeyListener;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.AbstractDataChangeListener;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.keychange.ConfigKeyChangeData;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.keychange.ConfigKeyChangeHandler;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.keychange.DefaultConfigKeyChangeHandler;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.utils.HussarConfigInfoUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigKeyChangeListener
extends AbstractDataChangeListener {
    private static final Logger log = LoggerFactory.getLogger(ConfigKeyChangeListener.class);
    private List<ConfigKeyListener> configKeyListenerList;
    private ConfigKeyChangeHandler configKeyChangeHandler;

    public ConfigKeyChangeListener(HussarCoreProperties hussarCoreProperties, List<ConfigKeyListener> configKeyListenerList) {
        super(hussarCoreProperties);
        this.configKeyListenerList = configKeyListenerList;
        this.configKeyChangeHandler = new DefaultConfigKeyChangeHandler();
    }

    public ConfigKeyChangeListener(HussarCoreProperties hussarCoreProperties, List<ConfigKeyListener> configKeyListenerList, ConfigKeyChangeHandler configKeyChangeHandler) {
        super(hussarCoreProperties);
        this.configKeyListenerList = configKeyListenerList;
        this.configKeyChangeHandler = configKeyChangeHandler;
    }

    @Override
    public void doDataChange(TableInfo tableInfo, List<ChangeRowData> changeRowDataList) {
        if (HussarUtils.isEmpty(this.configKeyListenerList)) {
            return;
        }
        String tableName = tableInfo.getTableName();
        TableFieldInfo tableFieldConfigValue = HussarConfigInfoUtils.getTableFieldInfo(tableInfo, "configValue");
        TableFieldInfo tableFieldConfigKey = HussarConfigInfoUtils.getTableFieldInfo(tableInfo, "configKey");
        if (HussarUtils.isEmpty((Object)tableFieldConfigValue) || HussarUtils.isEmpty((Object)tableFieldConfigKey)) {
            return;
        }
        ConfigKeyChangeData configKeyChangeData = new ConfigKeyChangeData();
        configKeyChangeData.setChangeRowDataList(changeRowDataList);
        configKeyChangeData.setConfigInfoConfigKey(tableFieldConfigKey.getColumn());
        configKeyChangeData.setConfigInfoConfigValue(tableFieldConfigValue.getColumn());
        configKeyChangeData.setConfigKeyListenerList(this.configKeyListenerList);
        this.configKeyChangeHandler.doConfigKeyChange(configKeyChangeData);
    }
}

