/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.locator;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.loader.ConfigInfoLoaderHandler;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.loader.ConfigTypeData;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.locator.HussarPropertySourceLocator;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.locator.data.ConfigInfoLocatorData;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.parse.ConfigInfoParserHandler;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.parse.data.ConfigInfoParserData;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.parse.data.GroupPropertySourceData;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.support.SpringFactoriesLoader;

public abstract class AbstractPropertySourceLocator
implements HussarPropertySourceLocator {
    private List<ConfigInfoLoaderHandler> configInfoLoaderHandlerList = new ArrayList<ConfigInfoLoaderHandler>();
    private List<ConfigInfoParserHandler> configInfoParserHandlerList = new ArrayList<ConfigInfoParserHandler>();

    public AbstractPropertySourceLocator() {
        this.configInfoLoaderHandlerList = SpringFactoriesLoader.loadFactories(ConfigInfoLoaderHandler.class, (ClassLoader)this.getClass().getClassLoader());
        this.configInfoParserHandlerList = SpringFactoriesLoader.loadFactories(ConfigInfoParserHandler.class, (ClassLoader)this.getClass().getClassLoader());
    }

    public AbstractPropertySourceLocator(List<ConfigInfoLoaderHandler> configInfoLoaderHandlerList) {
        this.configInfoLoaderHandlerList = configInfoLoaderHandlerList;
    }

    public List<ConfigInfoLoaderHandler> getConfigLoaderList() {
        return this.configInfoLoaderHandlerList;
    }

    public void setConfigLoaderList(List<ConfigInfoLoaderHandler> configInfoLoaderHandlerList) {
        this.configInfoLoaderHandlerList = configInfoLoaderHandlerList;
    }

    public abstract void doLocate(List<ConfigTypeData> var1);

    @Override
    public List<GroupPropertySourceData> locate(ConfigInfoLocatorData configInfoLocatorData) {
        ArrayList<ConfigTypeData> configTypeDataList = new ArrayList<ConfigTypeData>();
        for (ConfigInfoLoaderHandler cilh : this.configInfoLoaderHandlerList) {
            ConfigTypeData config;
            if (!cilh.support(configInfoLocatorData.getEnvironment()) || !HussarUtils.isNotEmpty((Object)(config = cilh.getConfig(configInfoLocatorData)))) continue;
            configTypeDataList.add(config);
        }
        this.doLocate(configTypeDataList);
        if (HussarUtils.isEmpty(configTypeDataList)) {
            return null;
        }
        ConfigInfoParserData configInfoParserData = null;
        ArrayList<GroupPropertySourceData> propertySourceList = new ArrayList<GroupPropertySourceData>();
        for (ConfigTypeData configTypeData : configTypeDataList) {
            configInfoParserData = new ConfigInfoParserData();
            configInfoParserData.setSourceType(configTypeData.getSourceType());
            configInfoParserData.setConfigInfoMap(configTypeData.getConfigInfoMap());
            for (ConfigInfoParserHandler ciph : this.configInfoParserHandlerList) {
                GroupPropertySourceData groupPropertySourceData;
                if (!ciph.support(configInfoParserData) || HussarUtils.isEmpty((Object)(groupPropertySourceData = ciph.load(configInfoParserData)))) continue;
                propertySourceList.add(groupPropertySourceData);
            }
        }
        return propertySourceList;
    }
}

