/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.propertysource;

import com.jxdinfo.hussar.platform.core.support.service.dto.TenantDetails;
import com.jxdinfo.hussar.platform.core.tenant.util.HussarTenantContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.config.manager.core.support.refresh.propertysource.ConfigInfoProperty;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.propertysource.HussarConfigPropertySource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class HussarTenantCodeCompositePropertySource
extends CompositePropertySource {
    private static final String DEFALULT_TENANT_CODE = "0";
    private final Set<PropertySource<?>> propertySources = new LinkedHashSet();

    public HussarTenantCodeCompositePropertySource(String name) {
        super(name);
    }

    public ConfigInfoProperty getConfigInfoProperty(String key) {
        HussarConfigPropertySource hussarConfigPropertySource;
        ConfigInfoProperty configInfoProperty;
        String tenantCode = this.getTenantCode();
        PropertySource<?> propertySourceByTenantCode = this.getPropertySourceByTenantCode(tenantCode);
        if (HussarUtils.isNotEmpty(propertySourceByTenantCode) && propertySourceByTenantCode instanceof HussarConfigPropertySource && HussarUtils.isNotEmpty((Object)(configInfoProperty = (hussarConfigPropertySource = (HussarConfigPropertySource)propertySourceByTenantCode).getConfigInfoProperty(key)))) {
            return configInfoProperty;
        }
        PropertySource<?> masterPropertySourceByTenantCode = this.getPropertySourceByTenantCode(DEFALULT_TENANT_CODE);
        if (HussarUtils.isNotEmpty(masterPropertySourceByTenantCode) && masterPropertySourceByTenantCode instanceof HussarConfigPropertySource) {
            HussarConfigPropertySource hussarConfigPropertySource2 = (HussarConfigPropertySource)masterPropertySourceByTenantCode;
            return hussarConfigPropertySource2.getConfigInfoProperty(key);
        }
        return null;
    }

    @Nullable
    public Object getProperty(String key) {
        Object candidate;
        PropertySource<?> currentPropertySource;
        String tenantCode = this.getTenantCode();
        if (!tenantCode.equals(DEFALULT_TENANT_CODE) && (currentPropertySource = this.getPropertySourceByTenantCode(tenantCode)) != null && HussarUtils.isNotEmpty((Object)(candidate = currentPropertySource.getProperty(key)))) {
            return candidate;
        }
        PropertySource<?> commonPropertySources = this.getCommonPropertySource();
        if (commonPropertySources != null && HussarUtils.isNotEmpty((Object)(candidate = commonPropertySources.getProperty(key)))) {
            return candidate;
        }
        return null;
    }

    public boolean containsProperty(String key) {
        PropertySource<?> commonPropertySources;
        PropertySource<?> currentPropertySource;
        String tenantCode = this.getTenantCode();
        boolean flag = false;
        if (!tenantCode.equals(DEFALULT_TENANT_CODE) && (currentPropertySource = this.getPropertySourceByTenantCode(tenantCode)) != null && currentPropertySource.containsProperty(key)) {
            flag = true;
        }
        if ((commonPropertySources = this.getCommonPropertySource()) != null && !flag && commonPropertySources.containsProperty(key)) {
            flag = true;
        }
        return flag;
    }

    public String[] getPropertyNames() {
        PropertySource<?> commonPropertySources;
        PropertySource<?> currentPropertySource;
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        String tenantCode = this.getTenantCode();
        if (!tenantCode.equals(DEFALULT_TENANT_CODE) && (currentPropertySource = this.getPropertySourceByTenantCode(tenantCode)) != null && currentPropertySource instanceof EnumerablePropertySource) {
            names.addAll(Arrays.asList(((EnumerablePropertySource)currentPropertySource).getPropertyNames()));
        }
        if ((commonPropertySources = this.getCommonPropertySource()) != null && commonPropertySources instanceof EnumerablePropertySource) {
            names.addAll(Arrays.asList(((EnumerablePropertySource)commonPropertySources).getPropertyNames()));
        }
        return StringUtils.toStringArray(names);
    }

    public void addPropertySource(PropertySource<?> propertySource) {
        this.propertySources.add(propertySource);
    }

    public void addFirstPropertySource(PropertySource<?> propertySource) {
        ArrayList existing = new ArrayList(this.propertySources);
        this.propertySources.clear();
        this.propertySources.add(propertySource);
        this.propertySources.addAll(existing);
    }

    public Collection<PropertySource<?>> getPropertySources() {
        return this.propertySources;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " {name='" + this.name + "', propertySources=" + this.propertySources + "}";
    }

    private String getTenantCode() {
        TenantDetails tenant = HussarTenantContextHolder.getTenant();
        if (HussarUtils.isEmpty((Object)tenant)) {
            return DEFALULT_TENANT_CODE;
        }
        return tenant.getTenantCode();
    }

    private PropertySource<?> getPropertySourceByTenantCode(String tenantCode) {
        if (HussarUtils.isEmpty((Object)tenantCode)) {
            tenantCode = DEFALULT_TENANT_CODE;
        }
        String tenantCodePropertiesName = "hussarConfigPropertiesTenantCode_";
        String propertySourceName = tenantCodePropertiesName + tenantCode;
        for (PropertySource<?> propertySource : this.propertySources) {
            if (!propertySource.getName().contains(propertySourceName)) continue;
            return propertySource;
        }
        return null;
    }

    private PropertySource<?> getCommonPropertySource() {
        return this.getPropertySourceByTenantCode(DEFALULT_TENANT_CODE);
    }
}

