/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.loader.boot;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.cache.support.properties.HussarCacheProperties;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.config.manager.core.properties.ConfigProperties;
import com.jxdinfo.hussar.support.config.manager.core.properties.DataBaseConfig;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigInfoEntity;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.loader.AbstractConfigInfoLoaderHandler;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.loader.ConfigTypeData;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.loader.client.jdbc.DefaultJdbcClient;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.loader.client.redis.DefaultRedisClient;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.locator.data.ConfigInfoLocatorData;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.utils.HussarConfigInfoUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.jdbc.support.JdbcUtils;

public abstract class AbstractJdbcConfigInfoLoaderHandler
extends AbstractConfigInfoLoaderHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractJdbcConfigInfoLoaderHandler.class);

    protected abstract List<ConfigInfoEntity> executeStmt(Statement var1, ConfigProperties var2) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigTypeData getConfig(ConfigInfoLocatorData configInfoLocatorData) {
        ConfigProperties configProperties = configInfoLocatorData.getConfigProperties();
        if (HussarUtils.isEmpty((Object)configProperties) || HussarUtils.isEmpty((Object)configProperties.getDatasource()) || HussarUtils.isEmpty((Object)configProperties.getDatasource().getDriverClassName()) || HussarUtils.isEmpty((Object)configProperties.getDatasource().getUrl()) || HussarUtils.isEmpty((Object)configProperties.getDatasource().getUsername()) || HussarUtils.isEmpty((Object)configProperties.getDatasource().getPassword())) {
            log.error("\u914d\u7f6e\u4e2d\u5fc3\u914d\u7f6e\u6570\u636e\u5e93\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u914d\u7f6e");
            return null;
        }
        Connection conn = null;
        Statement stmt = null;
        try {
            HussarCacheProperties hussarCacheProperties;
            DataBaseConfig datasource = configProperties.getDatasource();
            DefaultJdbcClient jdbcClient = DefaultJdbcClient.getInstance(datasource);
            conn = jdbcClient.getConnection();
            log.info("\u914d\u7f6e\u4e2d\u5fc3\u6210\u529f\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5");
            stmt = conn.createStatement();
            List<ConfigInfoEntity> configInfoEntityList = this.executeStmt(stmt, configProperties);
            if (SpringContextUtil.getBean(CacheManager.class) != null) {
                List changeData = (List)HussarFixedCacheUtil.get((String)"hussar_config", (Object)"refresh_change_data", List.class);
                HussarFixedCacheUtil.evict((String)"hussar_config", (Object)"refresh_change_data");
                if (HussarUtils.isNotEmpty((Object)changeData)) {
                    configInfoEntityList = this.mergeChangeData(changeData, configInfoEntityList);
                }
            }
            if (HussarUtils.isNotEmpty(configInfoEntityList) && (hussarCacheProperties = HussarConfigInfoUtils.buildHussarCacheProperties(configInfoLocatorData.getEnvironment())).getCacheType().equals("redis")) {
                DefaultRedisClient instance = DefaultRedisClient.getInstance(configInfoLocatorData.getEnvironment());
                instance.put("hussar_config", "refresh_cache", configInfoEntityList);
            }
            ConfigTypeData configTypeData = this.createMapPropertiesSourceByConfigEntity(configInfoEntityList);
            JdbcUtils.closeStatement((Statement)stmt);
            return configTypeData;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            JdbcUtils.closeStatement(stmt);
        }
        return null;
    }

    private List<ConfigInfoEntity> mergeChangeData(List<ConfigInfoEntity> changeData, List<ConfigInfoEntity> configInfoEntityList) {
        Map changeDataMap = changeData.stream().collect(Collectors.toMap(e -> e.getConfigKey() + "_" + e.getTenantCode(), Function.identity()));
        Map configInfoList = configInfoEntityList.stream().collect(Collectors.toMap(e -> e.getConfigKey() + "_" + e.getTenantCode(), Function.identity()));
        configInfoList.putAll(changeDataMap);
        return new ArrayList<ConfigInfoEntity>(configInfoList.values());
    }
}

