/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.getconfig;

import com.jxdinfo.hussar.support.config.manager.core.service.CustomPropertySource;
import com.jxdinfo.hussar.support.config.manager.core.support.refresh.propertysource.ConfigInfoProperty;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.getconfig.DefaultCustomPropertySource;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class WrapperCustomPropertySource
implements ApplicationContextAware,
CustomPropertySource {
    private ConfigurableApplicationContext applicationContext;
    private DefaultCustomPropertySource customPropertySource;

    public WrapperCustomPropertySource(DefaultCustomPropertySource customPropertySource) {
        this.customPropertySource = customPropertySource;
    }

    public WrapperCustomPropertySource() {
        this.customPropertySource = new DefaultCustomPropertySource();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        ConfigurableEnvironment environment = this.applicationContext.getEnvironment();
        this.customPropertySource.updateCustomPropertySource(environment);
    }

    public boolean containsProperty(String name) {
        return this.customPropertySource.containsProperty(name);
    }

    public String[] getPropertyNames() {
        return this.customPropertySource.getPropertyNames();
    }

    public ConfigInfoProperty getConfigInfoProperty(String name) {
        String property = this.applicationContext.getEnvironment().getProperty("hussar.config.enable");
        if (!Boolean.TRUE.toString().equals(property)) {
            throw new HussarException("\u672a\u5f00\u542f\u914d\u7f6e\u4e2d\u5fc3");
        }
        return this.customPropertySource.getConfigInfoProperty(name);
    }

    public Object getProperty(String name) {
        return this.customPropertySource.getProperty(name);
    }

    public List<ConfigInfoProperty> getConfigPropertyByGroupPath(String groupPath) {
        return this.customPropertySource.getConfigPropertyByGroupPath(groupPath);
    }

    public List<String> getConfigKeyByGroupPath(String groupPath) {
        return this.customPropertySource.getConfigKeyByGroupPath(groupPath);
    }

    protected DefaultCustomPropertySource getCustomPropertySource() {
        return this.customPropertySource;
    }
}

