/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.getconfig;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.convert.ConverterRegistry;
import com.jxdinfo.hussar.support.config.manager.core.service.CustomPropertySource;
import com.jxdinfo.hussar.support.config.manager.core.support.refresh.propertysource.ConfigInfoProperty;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.getconfig.composite.PropertySourceManager;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.propertysource.HussarTenantCodeCompositePropertySource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class DefaultCustomPropertySource
implements PropertySourceManager,
CustomPropertySource {
    private static final Logger log = LoggerFactory.getLogger(DefaultCustomPropertySource.class);
    private final Set<CompositePropertySource> propertySources = new LinkedHashSet<CompositePropertySource>();

    public boolean containsProperty(String name) {
        if (HussarUtils.isEmpty((Object)name)) {
            return false;
        }
        for (PropertySource propertySource : this.propertySources) {
            if (!propertySource.containsProperty(name)) continue;
            return true;
        }
        return false;
    }

    public String[] getPropertyNames() {
        LinkedHashSet<Object> names = new LinkedHashSet<Object>();
        for (CompositePropertySource propertySource : this.propertySources) {
            Object[] propertyNames = propertySource.getPropertyNames();
            if (!HussarUtils.isNotEmpty((Object[])propertyNames)) continue;
            names.addAll(Arrays.asList(propertyNames));
        }
        return StringUtils.toStringArray(names);
    }

    public ConfigInfoProperty getConfigInfoProperty(String name) {
        if (HussarUtils.isEmpty((Object)name)) {
            return null;
        }
        for (CompositePropertySource propertySource : this.propertySources) {
            HussarTenantCodeCompositePropertySource hussarTenantCodeCompositePropertySource;
            ConfigInfoProperty configInfoProperty;
            if (!HussarUtils.isNotEmpty((Object)propertySource) || !(propertySource instanceof HussarTenantCodeCompositePropertySource) || !HussarUtils.isNotEmpty((Object)(configInfoProperty = (hussarTenantCodeCompositePropertySource = (HussarTenantCodeCompositePropertySource)propertySource).getConfigInfoProperty(name)))) continue;
            return configInfoProperty;
        }
        return null;
    }

    public Object getProperty(String name) {
        Object convert;
        if (HussarUtils.isEmpty((Object)name)) {
            return null;
        }
        ConfigInfoProperty configInfoProperty = this.getConfigInfoProperty(name);
        if (HussarUtils.isEmpty((Object)configInfoProperty)) {
            return null;
        }
        try {
            Class<?> aClass = Class.forName(configInfoProperty.getValueType());
            ConverterRegistry instance = ConverterRegistry.getInstance();
            convert = instance.convert(aClass, (Object)configInfoProperty.getConfigValue());
        }
        catch (ClassNotFoundException e) {
            log.error("\u83b7\u53d6key:{" + name + "},value type:{" + configInfoProperty.getValueType() + "}, value:{" + configInfoProperty.getConfigValue() + "} \u83b7\u53d6\u503c\u5931\u8d25");
            return null;
        }
        return convert;
    }

    public List<ConfigInfoProperty> getConfigPropertyByGroupPath(String groupPath) {
        ArrayList<ConfigInfoProperty> configInfoPropertyList = new ArrayList<ConfigInfoProperty>();
        if (HussarUtils.isEmpty((Object)groupPath)) {
            return configInfoPropertyList;
        }
        List<String> configKeyByGroupPathList = this.getConfigKeyByGroupPath(groupPath);
        if (HussarUtils.isEmpty(configKeyByGroupPathList)) {
            return configInfoPropertyList;
        }
        configKeyByGroupPathList.stream().map(this::getConfigInfoProperty).filter(HussarUtils::isNotEmpty).forEach(configInfoPropertyList::add);
        return configInfoPropertyList;
    }

    public List<String> getConfigKeyByGroupPath(String groupPath) {
        if (HussarUtils.isEmpty((Object)groupPath)) {
            return null;
        }
        List<String> configKeyList = Arrays.stream(this.getPropertyNames()).filter(pn -> pn.startsWith(groupPath + ".")).collect(Collectors.toList());
        return configKeyList;
    }

    @Override
    public void addPropertySource(CompositePropertySource propertySource) {
        if (HussarUtils.isEmpty((Object)propertySource)) {
            return;
        }
        this.propertySources.add(propertySource);
    }

    @Override
    public void updateCustomPropertySource(ConfigurableEnvironment environment) {
        this.propertySources.clear();
        MutablePropertySources propertySources = environment.getPropertySources();
        CompositePropertySource compositePropertySource = (CompositePropertySource)propertySources.get("hussar_customer_config");
        if (HussarUtils.isEmpty((Object)compositePropertySource)) {
            return;
        }
        Collection propertySourcesList = compositePropertySource.getPropertySources();
        if (HussarUtils.isEmpty((Object)propertySourcesList)) {
            return;
        }
        propertySourcesList.stream().map(ps -> (CompositePropertySource)ps).forEach(this::addPropertySource);
    }

    @Override
    public void addPropertySource(Collection<CompositePropertySource> propertySources) {
        if (HussarUtils.isEmpty(propertySources)) {
            return;
        }
        this.propertySources.addAll(propertySources);
    }

    @Override
    public void addFirstPropertySource(CompositePropertySource propertySource) {
        if (HussarUtils.isEmpty((Object)propertySource)) {
            return;
        }
        ArrayList<CompositePropertySource> existing = new ArrayList<CompositePropertySource>(this.propertySources);
        this.propertySources.clear();
        this.propertySources.add(propertySource);
        this.propertySources.addAll(existing);
    }
}

