/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.plugin.refresh.support;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.config.manager.core.properties.ConfigProperties;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.locator.HussarPropertySourceLocator;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.locator.data.ConfigInfoLocatorData;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.parse.data.GroupPropertySourceData;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.propertysource.GroupTypePropertySourceEnum;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.utils.HussarConfigInfoUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class HussarSupportConfigEnvironmentProcessor
implements EnvironmentPostProcessor,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(HussarSupportConfigEnvironmentProcessor.class);
    private List<HussarPropertySourceLocator> propertySourceLocators = SpringFactoriesLoader.loadFactories(HussarPropertySourceLocator.class, (ClassLoader)this.getClass().getClassLoader());
    public static final String COMPOSITE_PROPERTYSOURCE_TYPE = "hussar_customer_config";
    private ConfigurableEnvironment environment;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.environment = environment;
        if (this.isInitialize(environment)) {
            ConfigProperties configProperties = HussarConfigInfoUtils.buildConfigProperties(this.environment);
            this.doInitialize(configProperties);
        }
    }

    private void doInitialize(ConfigProperties configProperties) {
        AnnotationAwareOrderComparator.sort(this.propertySourceLocators);
        ArrayList<GroupPropertySourceData> composite = new ArrayList<GroupPropertySourceData>();
        ConfigInfoLocatorData configInfoLocatorData = new ConfigInfoLocatorData();
        configInfoLocatorData.setConfigProperties(configProperties);
        configInfoLocatorData.setEnvironment(this.environment);
        if (HussarUtils.isEmpty(this.propertySourceLocators)) {
            this.logger.info("\u672a\u914d\u7f6epropertySourceLocators");
            return;
        }
        try {
            for (HussarPropertySourceLocator locator : this.propertySourceLocators) {
                List<GroupPropertySourceData> groupPropertySourceData = locator.locate(configInfoLocatorData);
                if (HussarUtils.isEmpty(groupPropertySourceData)) continue;
                composite.addAll(groupPropertySourceData);
            }
        }
        catch (Exception e) {
            this.logger.error("\u914d\u7f6e\u4e2d\u5fc3\u52a0\u8f7d\u5931\u8d25", (Throwable)e);
        }
        if (HussarUtils.isNotEmpty(composite)) {
            MutablePropertySources propertySources = this.environment.getPropertySources();
            this.insertPropertySources(propertySources, composite);
        }
    }

    private void insertPropertySources(MutablePropertySources environmentPropertySources, List<GroupPropertySourceData> composite) {
        ArrayList<GroupPropertySourceData> reversedComposite = new ArrayList<GroupPropertySourceData>(composite);
        Collections.reverse(reversedComposite);
        CompositePropertySource compositePropertySourceTotal = new CompositePropertySource(COMPOSITE_PROPERTYSOURCE_TYPE);
        CompositePropertySource compositePropertySourceType = null;
        for (GroupPropertySourceData gpsd : reversedComposite) {
            if (HussarUtils.isEmpty((Object)gpsd) || HussarUtils.isEmpty(gpsd.getPropertySources())) continue;
            compositePropertySourceType = GroupTypePropertySourceEnum.getGroupTypePropertySource(gpsd.getType());
            for (PropertySource<?> propertySource : gpsd.getPropertySources()) {
                compositePropertySourceType.addPropertySource(propertySource);
            }
            compositePropertySourceTotal.addPropertySource((PropertySource)compositePropertySourceType);
        }
        environmentPropertySources.addLast((PropertySource)compositePropertySourceTotal);
    }

    private boolean isInitialize(ConfigurableEnvironment environment) {
        if (HussarUtils.isEmpty((Object)environment)) {
            return false;
        }
        ConfigProperties configProperties = HussarConfigInfoUtils.buildConfigProperties(this.environment);
        return HussarUtils.isNotEmpty((Object)configProperties) && configProperties.isEnable();
    }

    public int getOrder() {
        return 0x7FFFFFFA;
    }
}

