/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.plugin.refresh.config;

import com.jxdinfo.hussar.platform.core.config.HussarCoreProperties;
import com.jxdinfo.hussar.support.config.manager.api.HussarConfigApi;
import com.jxdinfo.hussar.support.config.manager.core.service.CustomPropertySource;
import com.jxdinfo.hussar.support.config.manager.core.support.listener.ConfigKeyListener;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.api.impl.ConfigGetApiImpl;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.api.impl.HussarConfigApiImpl;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.getconfig.EnvironmentChangeEventListener;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.getconfig.WrapperCustomPropertySource;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.ConfigDataChangeListener;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.ConfigKeyChangeListener;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.cloud.CloudAsyncDataChangeListener;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.cloud.ConfigChangeSender;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.cloud.RedisConfigChangeListener;
import com.jxdinfo.hussar.support.config.manager.plugin.refresh.support.refresh.cloud.RedisConfigChangeSender;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;

@Configuration(proxyBeanMethods=false)
public class ConfigRefreshConfiguration {
    private final List<ConfigKeyListener> configKeyListenerList;

    public ConfigRefreshConfiguration(List<ConfigKeyListener> configKeyListenerList) {
        this.configKeyListenerList = configKeyListenerList;
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar.core", name={"enable-micro-service"}, havingValue="false", matchIfMissing=true)
    public ConfigDataChangeListener configDataChangeListener(HussarCoreProperties coreProperties) {
        return new ConfigDataChangeListener(coreProperties);
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar.core", name={"enable-micro-service"}, havingValue="false", matchIfMissing=true)
    public ConfigKeyChangeListener changeListener(HussarCoreProperties coreProperties) {
        return new ConfigKeyChangeListener(coreProperties, this.configKeyListenerList);
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar.core", name={"enable-micro-service"}, havingValue="true")
    public RedisConfigChangeListener redisConfigChangeListener(RedisTemplate redisTemplate, List<ConfigKeyListener> configKeyListenerList) {
        return new RedisConfigChangeListener(redisTemplate, configKeyListenerList);
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar.core", name={"enable-micro-service"}, havingValue="true")
    public ConfigChangeSender redisConfigChangeSender(RedisTemplate redisTemplate) {
        return new RedisConfigChangeSender(redisTemplate);
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar.core", name={"enable-micro-service"}, havingValue="true")
    public RedisMessageListenerContainer redisConfigChangeContainer(RedisConnectionFactory redisConnectionFactory, RedisConfigChangeListener redisConfigChangeListener) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(redisConnectionFactory);
        container.addMessageListener((MessageListener)redisConfigChangeListener, (Topic)new ChannelTopic("sync_change_config_channel"));
        return container;
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar.core", name={"enable-micro-service"}, havingValue="true")
    public CloudAsyncDataChangeListener cloudAsyncDataChangeListener(HussarCoreProperties coreProperties, ConfigChangeSender redisConfigChangeSender, List<ConfigKeyListener> configKeyListenerList) {
        return new CloudAsyncDataChangeListener(coreProperties, redisConfigChangeSender, configKeyListenerList);
    }

    @Bean
    public CustomPropertySource customPropertySource() {
        return new WrapperCustomPropertySource();
    }

    @Bean
    public EnvironmentChangeEventListener environmentChangeEventListener(CustomPropertySource customPropertySource) {
        return new EnvironmentChangeEventListener(customPropertySource);
    }

    @Bean
    @ConditionalOnMissingBean
    public HussarConfigApi hussarConfigApi() {
        return new HussarConfigApiImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConfigGetApiImpl configGetApi() {
        return new ConfigGetApiImpl();
    }
}

