/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.manager.plugin.mybatis.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.support.config.manager.core.enums.ValueTypeEnum;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigInfoEntity;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class ConfigMigrationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigMigrationUtil.class);

    public static String convertToYmlString(List<ConfigInfoEntity> configInfoEntityList) {
        HashMap<String, Object> ymlMap = new HashMap<String, Object>();
        for (ConfigInfoEntity infoEntity : configInfoEntityList) {
            String key = infoEntity.getConfigKey();
            String valueType = infoEntity.getValueType();
            Object value = null;
            try {
                value = ValueTypeEnum.VALUE_TYPE_STRING.getTypeName().equals(valueType) ? infoEntity.getConfigValue() : JSON.parseObject((String)infoEntity.getConfigValue(), Class.forName(valueType));
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("\u914d\u7f6e {} \u914d\u7f6e\u503c\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38, \u65e0\u6cd5\u5bfc\u51fa\u6b64\u914d\u7f6e\u9879\uff01\u5f02\u5e38\u4fe1\u606f\u4e3a{}", (Object)key, (Object)e.getMessage());
                continue;
            }
            catch (Exception e) {
                throw new HussarException((Throwable)e);
            }
            String[] keys = key.split("\\.");
            Map<String, Object> currentMap = ymlMap;
            for (int i = 0; i < keys.length - 1; ++i) {
                currentMap = (Map)currentMap.computeIfAbsent(keys[i], k -> new HashMap());
            }
            currentMap.put(keys[keys.length - 1], value);
        }
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(dumperOptions);
        return yaml.dump(ymlMap);
    }
}

