/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.manager.plugin.mybatis.support.service;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.GetConfigInfoDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.ConfigInfoDaoService;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.util.ConfigMigrationUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.config.manager.core.service.HussarConfigImportService;
import com.jxdinfo.hussar.support.config.manager.core.service.HussarConfigYAMLImpExpService;
import com.jxdinfo.hussar.support.config.manager.core.vo.ConfigImportDto;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigInfoEntity;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.yaml.snakeyaml.Yaml;

@HussarTransactional
@Service
public class HussarConfigYAMLImpExpServiceImpl
implements HussarConfigYAMLImpExpService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarConfigYAMLImpExpServiceImpl.class);
    @Autowired
    private ConfigInfoDaoService configInfoDaoService;
    @Autowired
    private HussarConfigImportService configImportService;

    public void importYmlConfig(MultipartFile file, Boolean enableUpdate) {
        try {
            InputStream inputStream = file.getInputStream();
            Yaml yaml = new Yaml();
            Map yamlMap = (Map)yaml.load(inputStream);
            ArrayList<ConfigImportDto> importDto = new ArrayList<ConfigImportDto>();
            this.flattenMap("", yamlMap, importDto);
            this.configImportService.importDate(importDto, Boolean.valueOf(true), Boolean.valueOf(true));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void flattenMap(String prefix, Map<String, Object> ymlMap, List<ConfigImportDto> importDto) {
        for (Map.Entry<String, Object> entry : ymlMap.entrySet()) {
            String key;
            String string = key = prefix.isEmpty() ? entry.getKey() : prefix + "." + entry.getKey();
            if (entry.getValue() instanceof Map) {
                this.flattenMap(key, (Map)entry.getValue(), importDto);
                continue;
            }
            if (HussarUtils.isEmpty((Object)entry.getValue())) {
                throw new HussarException(String.format("%s \u914d\u7f6e\u503c\u4e0d\u5f97\u4e3a\u7a7a", key));
            }
            String configValue = entry.getValue() instanceof String ? (String)entry.getValue() : JSON.toJSONString((Object)entry.getValue());
            String valueType = entry.getValue() instanceof Collection ? Collection.class.getName() : entry.getValue().getClass().getName();
            ConfigImportDto configImportDto = new ConfigImportDto();
            configImportDto.setConfigKey(key);
            configImportDto.setConfigName(entry.getKey());
            configImportDto.setConfigValue(configValue);
            configImportDto.setValueType(valueType);
            configImportDto.setConfigDesc(entry.getKey());
            importDto.add(configImportDto);
        }
    }

    public void exportYml(HttpServletResponse response) {
        GetConfigInfoDto getConfigInfoDto = new GetConfigInfoDto();
        List<ConfigInfoEntity> allConfigInfo = this.configInfoDaoService.getConfigInfo(getConfigInfoDto);
        String ymlString = ConfigMigrationUtil.convertToYmlString(allConfigInfo);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        try (BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            outputStream.write(ymlString.getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing response", e);
        }
    }
}

