/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.manager.plugin.mybatis.support.service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.GetConfigGroupDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.GetConfigInfoDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.ValidateConfigInfoDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.ConfigGroupDaoService;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.ConfigInfoDaoService;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.ConfigOptionDaoService;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.vo.ValidateGroupVo;
import com.jxdinfo.hussar.platform.core.base.entity.HussarTenantEntity;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.tenant.tenant.TenantConstant;
import com.jxdinfo.hussar.platform.core.tenant.util.HussarTenantContextHolder;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.DigestUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IpUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.config.manager.core.dto.ConfigInfoDto;
import com.jxdinfo.hussar.support.config.manager.core.enums.OperatorEnum;
import com.jxdinfo.hussar.support.config.manager.core.enums.ValueSourceEnum;
import com.jxdinfo.hussar.support.config.manager.core.enums.ValueTypeEnum;
import com.jxdinfo.hussar.support.config.manager.core.properties.ConfigProperties;
import com.jxdinfo.hussar.support.config.manager.core.service.HussarConfigInfoService;
import com.jxdinfo.hussar.support.config.manager.core.util.SetTenantUtil;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigGroupEntity;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigInfoEntity;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigOptionEntity;
import com.jxdinfo.hussar.support.config.manager.vo.ConfigInfoVo;
import com.jxdinfo.hussar.support.config.manager.vo.ConfigValueVo;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.query.enums.QueryRuleEnum;
import com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

@HussarTransactional
public class HussarConfigInfoServiceImpl
implements HussarConfigInfoService {
    @Autowired
    private ConfigInfoDaoService configInfoDaoService;
    @Autowired
    private ConfigGroupDaoService configGroupDaoService;
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private ConfigOptionDaoService configOptionDaoService;
    @Resource
    private HussarTenantProperties tenantProperties;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveConfigInfo(ConfigInfoDto configInfoDto) {
        ConfigGroupEntity configGroupEntity;
        if (HussarUtils.isEmpty((Object)configInfoDto) || HussarUtils.isEmpty((Object)configInfoDto.getSimpleKey()) || HussarUtils.isEmpty((Object)configInfoDto.getConfigValue()) || HussarUtils.isEmpty((Object)configInfoDto.getValueType()) || HussarUtils.isEmpty((Object)configInfoDto.getValueSource()) || HussarUtils.isEmpty((Object)configInfoDto.getConfigName())) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25\uff0c\u53c2\u6570\u4e3a\u7a7a");
        }
        this.validateOption(configInfoDto);
        if (HussarUtils.isNotEmpty((Object)configInfoDto.getConfigKey())) {
            throw new HussarException("\u65e0\u6cd5\u65b0\u589econfigKey");
        }
        this.configInfoDaoService.validateValueTypeCanCovert((ConfigInfoEntity)configInfoDto);
        SetTenantUtil.SetTenantIdCode((HussarTenantEntity)configInfoDto);
        if (HussarUtils.isEmpty((Object)configInfoDto.getGroupPath())) {
            configInfoDto.setGroupPath("default");
        }
        String groupPath = null;
        ValidateGroupVo validateGroupVo = this.configGroupDaoService.validateGroupPath(configInfoDto.getGroupPath());
        if (!validateGroupVo.isExist()) {
            if (!validateGroupVo.isDefault()) throw new HussarException("\u4f20\u9012\u5206\u7ec4\u7f16\u7801: {" + configInfoDto.getGroupPath() + "} \u4e0d\u5b58\u5728");
            configGroupEntity = this.configGroupDaoService.saveDefaultGroup();
            groupPath = configGroupEntity.getGroupPath();
        } else {
            configGroupEntity = validateGroupVo.getConfigGroupEntity();
            groupPath = configGroupEntity.getGroupPath();
        }
        ValidateConfigInfoDto validateConfigInfoDto = new ValidateConfigInfoDto();
        validateConfigInfoDto.setSimpleKey(configInfoDto.getSimpleKey());
        validateConfigInfoDto.setOperatorType(OperatorEnum.OPERATOR_SAVE.getType());
        validateConfigInfoDto.setTenantCode(configInfoDto.getTenantCode());
        validateConfigInfoDto.setGroupPath(configInfoDto.getGroupPath());
        boolean exist = this.configInfoDaoService.validateConfigKeyExist(validateConfigInfoDto);
        if (exist) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25\uff0c\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u914d\u7f6e\u6807\u8bc6");
        }
        ConfigInfoEntity configInfoEntity = new ConfigInfoEntity();
        configInfoEntity.setConfigDesc(configInfoDto.getConfigDesc());
        configInfoEntity.setConfigValue(configInfoDto.getConfigValue());
        configInfoEntity.setSimpleKey(configInfoDto.getSimpleKey());
        configInfoEntity.setConfigName(configInfoDto.getConfigName());
        configInfoEntity.setValueSource(configInfoDto.getValueSource());
        String configKey = groupPath + "." + configInfoDto.getSimpleKey();
        if ("default".equals(groupPath)) {
            configKey = configInfoDto.getSimpleKey();
        }
        configInfoEntity.setConfigKey(configKey);
        configInfoEntity.setGroupPath(configInfoDto.getGroupPath());
        configInfoEntity.setValueType(configInfoDto.getValueType());
        String md5Str = DigestUtil.md5Hex((String)configInfoDto.getConfigValue());
        configInfoEntity.setMd5(md5Str);
        String ip = IpUtils.getIp();
        configInfoEntity.setSourceIp(ip);
        configInfoEntity.setTenantCode(configInfoDto.getTenantCode());
        configInfoEntity.setTenantId(configInfoDto.getTenantId());
        configInfoEntity.setRangeType(HussarUtils.isEmpty((Object)configInfoDto.getRangeType()) ? "biz" : configInfoDto.getRangeType());
        this.configInfoDaoService.save(configInfoEntity);
        configInfoDto.setConfigKey(configInfoEntity.getConfigKey());
        this.saveConfigOptions((ConfigInfoEntity)configInfoDto);
        this.evictGroupPathCache();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateConfigInfo(ConfigInfoDto configInfoDto) {
        ConfigGroupEntity configGroupEntity;
        if (HussarUtils.isEmpty((Object)configInfoDto) || HussarUtils.isEmpty((Object)configInfoDto.getSimpleKey()) || HussarUtils.isEmpty((Object)configInfoDto.getConfigValue()) || HussarUtils.isEmpty((Object)configInfoDto.getGroupPath()) || HussarUtils.isEmpty((Object)configInfoDto.getConfigId()) || HussarUtils.isEmpty((Object)configInfoDto.getValueType()) || HussarUtils.isEmpty((Object)configInfoDto.getValueSource()) || HussarUtils.isEmpty((Object)configInfoDto.getConfigName())) {
            throw new HussarException("\u4fee\u6539\u5931\u8d25\uff0c\u53c2\u6570\u4e3a\u7a7a");
        }
        this.validateOption(configInfoDto);
        if (HussarUtils.isNotEmpty((Object)configInfoDto.getConfigKey())) {
            throw new HussarException("\u65e0\u6cd5\u4fee\u6539configKey");
        }
        this.configInfoDaoService.validateValueTypeCanCovert((ConfigInfoEntity)configInfoDto);
        String groupPath = null;
        ValidateGroupVo validateGroupVo = this.configGroupDaoService.validateGroupPath(configInfoDto.getGroupPath());
        if (!validateGroupVo.isExist()) {
            if (!validateGroupVo.isDefault()) throw new HussarException("\u4f20\u9012\u5206\u7ec4\u8def\u5f84: {" + configInfoDto.getGroupPath() + "} \u4e0d\u5b58\u5728");
            configGroupEntity = this.configGroupDaoService.saveDefaultGroup();
            groupPath = configGroupEntity.getGroupPath();
        } else {
            configGroupEntity = validateGroupVo.getConfigGroupEntity();
            groupPath = configGroupEntity.getGroupPath();
        }
        ValidateConfigInfoDto validateConfigInfoDto = new ValidateConfigInfoDto();
        validateConfigInfoDto.setSimpleKey(configInfoDto.getSimpleKey());
        validateConfigInfoDto.setOperatorType(OperatorEnum.OPERATOR_UPDATE.getType());
        validateConfigInfoDto.setUpdateConfigInfoId(configInfoDto.getConfigId());
        validateConfigInfoDto.setGroupPath(configInfoDto.getGroupPath());
        validateConfigInfoDto.setTenantCode(configInfoDto.getTenantCode());
        boolean exist = this.configInfoDaoService.validateConfigKeyExist(validateConfigInfoDto);
        if (exist) {
            throw new HussarException("\u5df2\u7ecf\u5b58\u5728[" + configInfoDto.getSimpleKey() + "]\u914d\u7f6ekey");
        }
        ConfigInfoEntity byId = (ConfigInfoEntity)this.configInfoDaoService.getById(configInfoDto.getConfigId());
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)byId), (String)"\u6307\u5b9aid\u7684\u914d\u7f6e\u9879\u4e0d\u5b58\u5728");
        this.configOptionDaoService.removeByConfigKey(Collections.singletonList(byId.getConfigKey()));
        String oldMd5 = byId.getMd5();
        String md5Str = DigestUtil.md5Hex((String)configInfoDto.getConfigValue());
        if (!HussarUtils.equals((Object)oldMd5, (Object)md5Str)) {
            configInfoDto.setMd5(md5Str);
        }
        String ip = IpUtils.getIp();
        configInfoDto.setSourceIp(ip);
        String configKey = groupPath + "." + configInfoDto.getSimpleKey();
        if ("default".equals(groupPath)) {
            configKey = configInfoDto.getSimpleKey();
        }
        configInfoDto.setConfigKey(configKey);
        configInfoDto.setRangeType(HussarUtils.isEmpty((Object)configInfoDto.getRangeType()) ? "biz" : configInfoDto.getRangeType());
        this.configInfoDaoService.updateById(configInfoDto);
        this.saveConfigOptions((ConfigInfoEntity)configInfoDto);
        this.evictGroupPathCache();
    }

    private void validateOption(ConfigInfoDto configInfoDto) {
        if (ValueSourceEnum.DROP_DOWN.getType().equals(configInfoDto.getValueSource())) {
            List configOptions = configInfoDto.getConfigOptions();
            HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)configOptions), (String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u914d\u7f6e\u53ef\u9009\u503c\u4e3a\u7a7a");
            Set optionValues = configOptions.stream().map(ConfigOptionEntity::getOptionValue).collect(Collectors.toSet());
            List values = null;
            values = ValueTypeEnum.VALUE_TYPE_COLLECTION.getTypeName().equals(configInfoDto.getValueType()) ? JSON.parseArray((String)configInfoDto.getConfigValue(), String.class) : Collections.singletonList(configInfoDto.getConfigValue());
            HussarException.throwBy((!optionValues.containsAll(values) ? 1 : 0) != 0, (String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u914d\u7f6e\u503c\u4e0e\u914d\u7f6e\u53ef\u9009\u53c2\u6570\u503c\u4e0d\u5339\u914d");
        }
    }

    private void saveConfigOptions(ConfigInfoEntity configInfoEntity) {
        List configOptions = configInfoEntity.getConfigOptions();
        if (HussarUtils.isNotEmpty((Object)configOptions)) {
            this.configOptionDaoService.saveBatchOptions(configOptions, configInfoEntity.getConfigKey());
        }
    }

    public void deleteConfigInfo(List<Long> ids) {
        if (HussarUtils.isEmpty(ids)) {
            return;
        }
        ids.stream().forEach(this::deleteConfigInfo);
        this.evictGroupPathCache();
    }

    public void deleteConfigInfo(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            return;
        }
        this.configOptionDaoService.removeByConfigId(id);
        this.configInfoDaoService.removeById(id);
        this.evictGroupPathCache();
    }

    public ConfigInfoVo getConfigInfoById(Long configId) {
        if (HussarUtils.isEmpty((Object)configId)) {
            return null;
        }
        GetConfigInfoDto getConfigInfoDto = new GetConfigInfoDto();
        getConfigInfoDto.setConfigId(configId);
        List<ConfigInfoEntity> configInfoList = this.configInfoDaoService.getConfigInfo(getConfigInfoDto);
        if (HussarUtils.isEmpty(configInfoList)) {
            return null;
        }
        ConfigInfoEntity configInfoEntity = configInfoList.get(0);
        this.fillGroupName(Collections.singleton(configInfoEntity));
        return (ConfigInfoVo)BeanUtil.copy((Object)configInfoEntity, ConfigInfoVo.class);
    }

    public IPage<ConfigInfoEntity> listPage(ConfigInfoDto configInfoDto, Page<ConfigInfoEntity> page, HttpServletRequest req) {
        SetTenantUtil.SetTenantCode((HussarTenantEntity)configInfoDto);
        SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
        QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)configInfoDto, req.getParameterMap());
        IPage pageList = this.configInfoDaoService.page((IPage)page, (Wrapper)queryWrapper);
        this.fillGroupName(pageList.getRecords());
        return pageList;
    }

    public List<ConfigInfoEntity> list(ConfigInfoDto configInfoDto, HttpServletRequest req) {
        SetTenantUtil.SetTenantCode((HussarTenantEntity)configInfoDto);
        SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
        QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)configInfoDto, req.getParameterMap());
        List list = this.configInfoDaoService.list((Wrapper)queryWrapper);
        this.fillGroupName(list);
        return list;
    }

    private void fillGroupName(Collection<ConfigInfoEntity> infoEntityList) {
        if (HussarUtils.isNotEmpty(infoEntityList)) {
            Set<String> collect = infoEntityList.stream().map(ConfigInfoEntity::getGroupPath).collect(Collectors.toSet());
            GetConfigGroupDto getConfigGroupDto = new GetConfigGroupDto();
            getConfigGroupDto.addParameter("groupPath" + QueryRuleEnum.IN, collect.toArray(new String[0]));
            Map<String, String> map = this.configGroupDaoService.getConfigGroup(getConfigGroupDto).stream().collect(Collectors.toMap(ConfigGroupEntity::getGroupPath, ConfigGroupEntity::getGroupName));
            infoEntityList.forEach(infoEntity -> infoEntity.setGroupName((String)map.get(infoEntity.getGroupPath())));
        }
    }

    public List<ConfigValueVo> getConfigByGroupPath(String groupPath) {
        List commonInfos = (List)HussarFixedCacheUtil.get((String)"hussar_config", (Object)("group_path:" + groupPath), List.class);
        if (commonInfos == null) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(ConfigInfoEntity.class).and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)i.eq(HussarTenantEntity::getTenantCode, (Object)"0");
            });
            if (HussarUtils.isNotEmpty((Object)groupPath)) {
                wrapper.likeRight(ConfigInfoEntity::getConfigKey, (Object)(groupPath + "."));
            }
            List configInfos = this.configInfoDaoService.list((Wrapper)wrapper);
            commonInfos = BeanUtil.copy((Collection)configInfos, ConfigValueVo.class);
            HussarFixedCacheUtil.put((String)"hussar_config", (Object)("group_path:" + groupPath), (Object)commonInfos, (long)this.configProperties.getCacheTime());
        }
        List tenantInfos = null;
        if (this.tenantProperties.isEnabled() && !"0".equals(HussarTenantContextHolder.getTenant().getTenantCode()) && (tenantInfos = (List)HussarCacheUtil.get((String)"hussar_config", (Object)("group_path:" + groupPath), List.class)) == null) {
            GetConfigInfoDto tenantGetInfo = new GetConfigInfoDto();
            if (HussarUtils.isNotEmpty((Object)groupPath)) {
                tenantGetInfo.addParameter("configKey" + QueryRuleEnum.RIGHT_LIKE.getValue(), groupPath + ".");
            }
            List<ConfigInfoEntity> configInfos = this.configInfoDaoService.getConfigInfo(tenantGetInfo);
            tenantInfos = BeanUtil.copy(configInfos, ConfigValueVo.class);
            HussarCacheUtil.put((String)"hussar_config", (Object)("group_path:" + groupPath), (Object)tenantInfos, (long)this.configProperties.getCacheTime());
        }
        HashMap<String, ConfigValueVo> result = new HashMap<String, ConfigValueVo>();
        if (HussarUtils.isNotEmpty((Object)commonInfos)) {
            for (ConfigValueVo commonInfo : commonInfos) {
                result.put(commonInfo.getConfigKey(), commonInfo);
            }
        }
        if (HussarUtils.isNotEmpty(tenantInfos)) {
            for (ConfigValueVo tenantInfo : tenantInfos) {
                result.put(tenantInfo.getConfigKey(), tenantInfo);
            }
        }
        return new ArrayList<ConfigValueVo>(result.values());
    }

    private void evictGroupPathCache() {
        if (Objects.equals(HussarTenantContextHolder.getTenant().getTenantCode(), TenantConstant.DEFAULT_TENANT_CODE)) {
            HussarFixedCacheUtil.evictKeysLike((String)"hussar_config", (String)"group_path");
        } else {
            HussarCacheUtil.evictKeysLike((String)"hussar_config", (String)"group_path");
        }
    }
}

