/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.manager.plugin.mybatis.support.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.GetConfigGroupDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.GetConfigInfoDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.ConfigInfoDaoMigrationService;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.ConfigInfoDaoService;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.ConfigOptionDaoService;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.impl.ConfigGroupDaoServiceImpl;
import com.jxdinfo.hussar.platform.core.base.entity.HussarTenantEntity;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.DigestUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IpUtils;
import com.jxdinfo.hussar.support.config.manager.core.constants.ConfigConstant;
import com.jxdinfo.hussar.support.config.manager.core.dto.ConfigGroupDto;
import com.jxdinfo.hussar.support.config.manager.core.enums.ValueSourceEnum;
import com.jxdinfo.hussar.support.config.manager.core.service.HussarConfigImportService;
import com.jxdinfo.hussar.support.config.manager.core.util.SetTenantUtil;
import com.jxdinfo.hussar.support.config.manager.core.vo.ConfigImportDto;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigGroupEntity;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigInfoEntity;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigOptionEntity;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTransactional
public class HussarConfigImportServiceImpl
implements HussarConfigImportService {
    @Autowired
    private ConfigInfoDaoService configInfoDaoService;
    @Autowired
    private ConfigGroupDaoServiceImpl configGroupDaoService;
    @Autowired
    private ConfigOptionDaoService configOptionDaoService;
    @Autowired
    private ConfigInfoDaoMigrationService configInfoDaoMigrationService;
    @Autowired
    private SeqBuilder seqBuilder;

    public void importDate(List<ConfigImportDto> importData, Boolean enableInsert, Boolean enableUpdate) {
        Map<String, Long> exitConfig = this.configInfoDaoService.getConfigInfo(new GetConfigInfoDto()).stream().collect(Collectors.toMap(ConfigInfoEntity::getConfigKey, ConfigInfoEntity::getConfigId));
        ArrayList<ConfigImportDto> saveConfigs = new ArrayList<ConfigImportDto>();
        ArrayList<ConfigImportDto> updateConfigs = new ArrayList<ConfigImportDto>();
        for (ConfigImportDto importDto : importData) {
            if (exitConfig.containsKey(importDto.getConfigKey())) {
                importDto.setConfigId(exitConfig.get(importDto.getConfigKey()));
                updateConfigs.add(importDto);
                continue;
            }
            saveConfigs.add(importDto);
        }
        if (enableInsert.booleanValue()) {
            this.insertData(saveConfigs);
        }
        if (enableUpdate.booleanValue()) {
            this.updateData(updateConfigs);
        }
    }

    public void insertData(List<ConfigImportDto> data) {
        Map<String, Collection<ConfigGroupEntity>> saveAndUpdateGroupMap = this.getSaveAndUpdateGroups(data);
        Collection<ConfigGroupEntity> saveGroups = saveAndUpdateGroupMap.get("save");
        Collection<ConfigGroupEntity> updateGroups = saveAndUpdateGroupMap.get("update");
        ArrayList<ConfigInfoEntity> saveConfigInfos = new ArrayList<ConfigInfoEntity>();
        ArrayList<ConfigOptionEntity> saveOptionList = new ArrayList<ConfigOptionEntity>();
        for (ConfigImportDto configImportDto : data) {
            ConfigInfoEntity configInfoEntity = this.getConfigInfoEntity(configImportDto, saveOptionList);
            saveConfigInfos.add(configInfoEntity);
        }
        this.configGroupDaoService.updateBatchById(updateGroups);
        this.configGroupDaoService.saveBatch(saveGroups);
        this.configInfoDaoMigrationService.saveBatch(saveConfigInfos);
        this.configOptionDaoService.saveBatch(saveOptionList);
    }

    public void updateData(List<ConfigImportDto> datas) {
        ArrayList<ConfigInfoEntity> updatedConfigInfos = new ArrayList<ConfigInfoEntity>();
        HashSet<String> delOptionKey = new HashSet<String>();
        ArrayList<ConfigOptionEntity> saveOptionList = new ArrayList<ConfigOptionEntity>();
        for (ConfigImportDto configImportDto : datas) {
            delOptionKey.add(configImportDto.getConfigKey());
            ConfigInfoEntity configInfoEntity = this.getConfigInfoEntity(configImportDto, saveOptionList);
            updatedConfigInfos.add(configInfoEntity);
        }
        this.configInfoDaoMigrationService.updateBatchById(updatedConfigInfos);
        if (HussarUtils.isNotEmpty(delOptionKey)) {
            this.configOptionDaoService.remove((Wrapper)Wrappers.lambdaQuery(ConfigOptionEntity.class).in(ConfigOptionEntity::getConfigKey, delOptionKey));
        }
        this.configOptionDaoService.saveBatch(saveOptionList);
    }

    private List<ConfigOptionEntity> getOptionEntities(String configKey, String configOptionValues) {
        ConfigOptionEntity configOptionEntity;
        ArrayList<ConfigOptionEntity> saveOptions = new ArrayList<ConfigOptionEntity>();
        if (this.canBeArray(configOptionValues)) {
            Set options = (Set)JSON.parseObject((String)configOptionValues, (TypeReference)new TypeReference<Set<String>>(){}, (Feature[])new Feature[0]);
            for (String option : options) {
                configOptionEntity = new ConfigOptionEntity();
                configOptionEntity.setConfigKey(configKey);
                configOptionEntity.setSourceType("0");
                configOptionEntity.setOptionValue(option);
                SetTenantUtil.SetTenantIdCode((HussarTenantEntity)configOptionEntity);
                saveOptions.add(configOptionEntity);
            }
        }
        if (this.canBeObject(configOptionValues)) {
            JSONObject jsonObject = JSON.parseObject((String)configOptionValues);
            for (String key : jsonObject.keySet()) {
                configOptionEntity = new ConfigOptionEntity();
                configOptionEntity.setConfigKey(configKey);
                configOptionEntity.setSourceType("0");
                configOptionEntity.setOptionValue(key);
                configOptionEntity.setOptionName(jsonObject.getString(key));
                SetTenantUtil.SetTenantIdCode((HussarTenantEntity)configOptionEntity);
                saveOptions.add(configOptionEntity);
            }
        }
        return saveOptions;
    }

    private Map<String, Collection<ConfigGroupEntity>> getSaveAndUpdateGroups(List<ConfigImportDto> datas) {
        List<ConfigGroupEntity> exitGroups = this.configGroupDaoService.getConfigGroup(new GetConfigGroupDto());
        Map<String, ConfigGroupEntity> exitGroupMap = exitGroups.stream().collect(Collectors.toMap(ConfigGroupEntity::getGroupPath, Function.identity()));
        HashMap<String, ConfigGroupEntity> saveGroupList = new HashMap<String, ConfigGroupEntity>();
        ArrayList<ConfigGroupEntity> updateGroupList = new ArrayList<ConfigGroupEntity>();
        for (ConfigImportDto configImportDto : datas) {
            String groupPath;
            String configKey = configImportDto.getConfigKey();
            String string = groupPath = configKey.contains(".") ? configKey.substring(0, configKey.lastIndexOf(".")) : "default";
            if ("default".equals(groupPath) && !exitGroupMap.containsKey("default")) {
                ConfigGroupEntity defaultGroup = this.configGroupDaoService.saveDefaultGroup();
                exitGroupMap.put(defaultGroup.getGroupPath(), defaultGroup);
            }
            String[] split = groupPath.split("\\.");
            String prefix = "";
            for (String groupCode : split) {
                String newPath = prefix + groupCode;
                if (!exitGroupMap.containsKey(newPath)) {
                    Long parentId = this.getParentId(prefix, saveGroupList, exitGroupMap);
                    ConfigGroupEntity configGroupEntity = this.getConfigGroupEntity(groupCode, parentId, newPath);
                    saveGroupList.put(newPath, configGroupEntity);
                }
                prefix = newPath + ".";
            }
        }
        Collection<ConfigGroupEntity> groupEntities = saveGroupList.values();
        this.fillIsLeaf(groupEntities, updateGroupList, exitGroups);
        HashMap<String, Collection<ConfigGroupEntity>> resultMap = new HashMap<String, Collection<ConfigGroupEntity>>();
        resultMap.put("save", groupEntities);
        resultMap.put("update", updateGroupList);
        return resultMap;
    }

    private Long getParentId(String prefix, Map<String, ConfigGroupEntity> saveGroup, Map<String, ConfigGroupEntity> exitGroup) {
        Long parentId = null;
        if (prefix.isEmpty()) {
            parentId = ConfigConstant.defaultParentId;
        } else if (prefix.endsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (exitGroup.containsKey(prefix)) {
            parentId = exitGroup.get(prefix).getGroupId();
        }
        if (saveGroup.containsKey(prefix)) {
            parentId = saveGroup.get(prefix).getGroupId();
        }
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)parentId), (String)"\u8ba1\u7b97\u9519\u8bef\uff0c\u672a\u53d6\u5230\u7236\u7ea7id");
        return parentId;
    }

    private ConfigGroupEntity getConfigGroupEntity(String groupCode, Long parentId, String groupPath) {
        ConfigGroupDto configGroupEntity = new ConfigGroupDto();
        configGroupEntity.setGroupId(this.getId());
        configGroupEntity.setConfigType(ConfigConstant.defaultConfigType);
        configGroupEntity.setGroupCode(groupCode);
        configGroupEntity.setGroupDesc(groupCode);
        configGroupEntity.setGroupName(groupCode);
        SetTenantUtil.SetTenantIdCode((HussarTenantEntity)configGroupEntity);
        configGroupEntity.setParentGroupId(parentId);
        configGroupEntity.setGroupPath(groupPath);
        return configGroupEntity;
    }

    private ConfigInfoEntity getConfigInfoEntity(ConfigImportDto configImportDto, List<ConfigOptionEntity> saveOptionList) {
        String configKey = configImportDto.getConfigKey();
        String groupPath = configKey.contains(".") ? configKey.substring(0, configKey.lastIndexOf(46)) : "default";
        String simpleKey = configKey.contains(".") ? configKey.substring(configKey.lastIndexOf(46) + 1) : configKey;
        ConfigInfoEntity configInfoEntity = (ConfigInfoEntity)BeanUtil.copyProperties((Object)configImportDto, ConfigInfoEntity.class);
        configInfoEntity.setGroupPath(groupPath);
        configInfoEntity.setConfigKey(configKey);
        configInfoEntity.setMd5(DigestUtil.md5Hex((String)configImportDto.getConfigValue()));
        configInfoEntity.setSourceIp(IpUtils.getIp());
        configInfoEntity.setSimpleKey(simpleKey);
        configInfoEntity.setValueSource(ValueSourceEnum.NORMAL.getType());
        SetTenantUtil.SetTenantIdCode((HussarTenantEntity)configInfoEntity);
        if (HussarUtils.isNotEmpty((Object)configImportDto.getConfigOptionValues())) {
            configInfoEntity.setValueSource(ValueSourceEnum.DROP_DOWN.getType());
            List<ConfigOptionEntity> configOptionEntity = this.getOptionEntities(configImportDto.getConfigKey(), configImportDto.getConfigOptionValues());
            saveOptionList.addAll(configOptionEntity);
        }
        return configInfoEntity;
    }

    private void fillIsLeaf(Collection<ConfigGroupEntity> addGroups, Collection<ConfigGroupEntity> updateGroups, Collection<ConfigGroupEntity> exitGroups) {
        Set parentIds = addGroups.stream().map(ConfigGroupEntity::getParentGroupId).collect(Collectors.toSet());
        parentIds.addAll(exitGroups.stream().map(ConfigGroupEntity::getParentGroupId).collect(Collectors.toSet()));
        for (ConfigGroupEntity groupEntity : addGroups) {
            groupEntity.setIsLeaf(parentIds.contains(groupEntity.getGroupId()) ? ConfigConstant.no_leaf : ConfigConstant.is_leaf);
        }
        for (ConfigGroupEntity exitGroup : exitGroups) {
            if (!parentIds.contains(exitGroup.getGroupId()) || ConfigConstant.no_leaf.equals(exitGroup.getIsLeaf())) continue;
            exitGroup.setIsLeaf(ConfigConstant.no_leaf);
            updateGroups.add(exitGroup);
        }
    }

    private boolean canBeArray(String json) {
        if (HussarUtils.isEmpty((Object)json)) {
            return false;
        }
        try {
            JSON.parseArray((String)json);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean canBeObject(String json) {
        if (HussarUtils.isEmpty((Object)json)) {
            return false;
        }
        try {
            JSON.parseObject((String)json);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Long getId() {
        return this.seqBuilder.build().nextValue();
    }
}

