/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.manager.plugin.mybatis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.GetConfigOptionDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.mapper.ConfigOptionMapper;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.ConfigOptionDaoService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarTenantEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.config.manager.core.util.SetTenantUtil;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigOptionEntity;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
public class ConfigOptionDaoServiceImpl
extends HussarServiceImpl<ConfigOptionMapper, ConfigOptionEntity>
implements ConfigOptionDaoService {
    @Autowired
    private ConfigOptionMapper configOptionMapper;

    @Override
    public List<ConfigOptionEntity> getConfigOption(GetConfigOptionDto getConfigOptionDto) {
        if (HussarUtils.isEmpty((Object)((Object)getConfigOptionDto))) {
            return null;
        }
        if (HussarUtils.isEmpty((Object)getConfigOptionDto.getTenantCode())) {
            SetTenantUtil.SetTenantCode((HussarTenantEntity)getConfigOptionDto);
        }
        SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
        QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)getConfigOptionDto, getConfigOptionDto.getParameterMap());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void removeByConfigKey(Collection<String> configKeys) {
        this.remove((Wrapper)Wrappers.lambdaQuery(ConfigOptionEntity.class).in(ConfigOptionEntity::getConfigKey, configKeys));
    }

    @Override
    public boolean removeByConfigId(Long id) {
        return this.configOptionMapper.removeByConfigId(id);
    }

    @Override
    public void saveBatchOptions(List<ConfigOptionEntity> configOptionEntityList, String configKey) {
        for (ConfigOptionEntity configOptionEntity : configOptionEntityList) {
            if (HussarUtils.isNotEmpty((Object)configKey)) {
                configOptionEntity.setConfigKey(configKey);
            }
            HussarException.throwBy((HussarUtils.isEmpty((Object)configOptionEntity.getConfigKey()) || HussarUtils.isEmpty((Object)configOptionEntity.getOptionValue()) ? 1 : 0) != 0, (String)"\u6279\u91cf\u4fdd\u5b58\u53ef\u9009\u9879\u5931\u8d25\uff0c\u53c2\u6570\u4e3a\u7a7a");
            configOptionEntity.setOptionId(null);
            configOptionEntity.setSourceType("0");
            configOptionEntity.setOptionName(HussarUtils.isEmpty((Object)configOptionEntity.getOptionName()) ? configOptionEntity.getOptionValue() : configOptionEntity.getOptionName());
            SetTenantUtil.SetTenantIdCode((HussarTenantEntity)configOptionEntity);
        }
        this.saveBatch(configOptionEntityList);
    }
}

