/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.manager.plugin.mybatis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.GetConfigGroupDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.GetGroupTreeDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.GetParentGroupDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.ValidateConfigGroupDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.mapper.ConfigGroupMapper;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.ConfigGroupDaoService;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.vo.ValidateGroupVo;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarTenantEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.TenantDetails;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.tenant.util.HussarTenantContextHolder;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.config.manager.core.constants.ConfigConstant;
import com.jxdinfo.hussar.support.config.manager.core.enums.OperatorEnum;
import com.jxdinfo.hussar.support.config.manager.core.util.SetTenantUtil;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigGroupEntity;
import com.jxdinfo.hussar.support.config.manager.vo.ConfigGroupTreeVo;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
public class ConfigGroupDaoServiceImpl
extends HussarServiceImpl<ConfigGroupMapper, ConfigGroupEntity>
implements ConfigGroupDaoService {
    private static final Logger log = LoggerFactory.getLogger(ConfigGroupDaoServiceImpl.class);
    @Autowired
    private HussarTenantProperties tenantProperties;
    @Autowired
    private ConfigGroupMapper configGroupMapper;

    @Override
    public boolean validateGroupCodeExist(ValidateConfigGroupDto validateConfigGroupDto) {
        if (HussarUtils.isEmpty((Object)validateConfigGroupDto) || HussarUtils.isEmpty((Object)validateConfigGroupDto.getOperatorType())) {
            log.error("\u9a8c\u8bc1 groupCode \u662f\u5426\u4e3a\u7a7a\u5931\u8d25\uff0c\u4f20\u9012\u53c2\u6570\u4e3a\u7a7a");
            return true;
        }
        LambdaQueryWrapper validateQuery = Wrappers.lambdaQuery();
        validateQuery.eq(ConfigGroupEntity::getGroupCode, (Object)validateConfigGroupDto.getGroupCode());
        if (HussarUtils.equals((Object)validateConfigGroupDto.getOperatorType(), (Object)OperatorEnum.OPERATOR_UPDATE.getType())) {
            validateQuery.ne(ConfigGroupEntity::getGroupId, (Object)validateConfigGroupDto.getUpdateConfigGroupId());
        }
        validateQuery.eq(HussarUtils.isNotEmpty((Object)validateConfigGroupDto.getParentGroupId()), ConfigGroupEntity::getParentGroupId, (Object)validateConfigGroupDto.getParentGroupId());
        if (HussarUtils.isNotEmpty((Object)validateConfigGroupDto.getTenantCode())) {
            validateQuery.eq(HussarUtils.isNotEmpty((Object)validateConfigGroupDto.getTenantCode()), HussarTenantEntity::getTenantCode, (Object)validateConfigGroupDto.getTenantCode());
        } else if (this.tenantProperties.isEnabled()) {
            TenantDetails tenant = HussarTenantContextHolder.getTenant();
            validateQuery.eq(HussarTenantEntity::getTenantCode, (Object)tenant.getTenantCode());
        }
        long count = this.count((Wrapper)validateQuery);
        return count > 0L;
    }

    @Override
    public List<ConfigGroupEntity> getConfigGroup(GetConfigGroupDto getConfigGroupDto) {
        if (HussarUtils.isEmpty((Object)getConfigGroupDto)) {
            return null;
        }
        ConfigGroupEntity queryConfigGroup = (ConfigGroupEntity)BeanUtil.copyProperties((Object)getConfigGroupDto, ConfigGroupEntity.class);
        if (HussarUtils.isEmpty((Object)queryConfigGroup.getTenantCode())) {
            SetTenantUtil.SetTenantCode((HussarTenantEntity)queryConfigGroup);
        }
        SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
        QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)queryConfigGroup, getConfigGroupDto.getParameterMap());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public ConfigGroupEntity saveDefaultGroup() {
        ConfigGroupEntity configGroupEntity = new ConfigGroupEntity();
        configGroupEntity.setGroupName("\u9ed8\u8ba4\u5206\u7ec4");
        configGroupEntity.setGroupCode("default");
        configGroupEntity.setGroupPath("default");
        configGroupEntity.setParentGroupId(ConfigConstant.defaultParentId);
        configGroupEntity.setGroupDesc("\u9ed8\u8ba4\u5206\u7ec4");
        configGroupEntity.setConfigType(ConfigConstant.defaultConfigType);
        SetTenantUtil.SetTenantIdCode((HussarTenantEntity)configGroupEntity);
        configGroupEntity.setIsLeaf(ConfigConstant.is_leaf);
        this.save((BaseEntity)configGroupEntity);
        return configGroupEntity;
    }

    @Override
    public ValidateGroupVo validateGroupPath(String groupPath) {
        ValidateGroupVo validateGroupVo = new ValidateGroupVo();
        if (HussarUtils.equals((Object)groupPath, (Object)"default")) {
            validateGroupVo.setDefault(true);
        }
        LambdaQueryWrapper validateQuery = Wrappers.lambdaQuery();
        validateQuery.eq(ConfigGroupEntity::getGroupPath, (Object)groupPath);
        if (this.tenantProperties.isEnabled()) {
            TenantDetails tenant = HussarTenantContextHolder.getTenant();
            validateQuery.eq(HussarTenantEntity::getTenantCode, (Object)tenant.getTenantCode());
        }
        ConfigGroupEntity one = (ConfigGroupEntity)this.getOne((Wrapper)validateQuery);
        validateGroupVo.setExist(HussarUtils.isNotEmpty((Object)one));
        validateGroupVo.setConfigGroupEntity(one);
        return validateGroupVo;
    }

    @Override
    public List<ConfigGroupEntity> getGroupByParentId(GetParentGroupDto getParentGroupDto) {
        if (HussarUtils.isEmpty((Object)getParentGroupDto)) {
            return null;
        }
        if (HussarUtils.isEmpty((Object)getParentGroupDto.getParentId())) {
            getParentGroupDto.setParentId(ConfigConstant.defaultParentId);
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ConfigGroupEntity::getParentGroupId, (Object)getParentGroupDto.getParentId());
        queryWrapper.ne(HussarUtils.isNotEmpty((Object)getParentGroupDto.getCurrentId()), ConfigGroupEntity::getGroupId, (Object)getParentGroupDto.getCurrentId());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ConfigGroupTreeVo> getGroupTree(GetGroupTreeDto getGroupTreeDto) {
        if (this.tenantProperties.isEnabled()) {
            TenantDetails tenant = HussarTenantContextHolder.getTenant();
            getGroupTreeDto.setTenantCode(tenant.getTenantCode());
        }
        return this.configGroupMapper.getGroupTreeVo(getGroupTreeDto);
    }

    @Override
    public void setGroupIsLeaf(Long groupId, boolean isLeaf) {
        if (ConfigConstant.defaultParentId.equals(groupId)) {
            return;
        }
        ConfigGroupEntity configGroupEntity = new ConfigGroupEntity();
        configGroupEntity.setGroupId(groupId);
        configGroupEntity.setIsLeaf(isLeaf ? ConfigConstant.is_leaf : ConfigConstant.no_leaf);
        this.updateById((BaseEntity)configGroupEntity);
    }

    @Override
    public void updateParentIsLeaf(Long groupId) {
        if (ConfigConstant.defaultParentId.equals(groupId)) {
            return;
        }
        long count = this.count((Wrapper)Wrappers.lambdaQuery(ConfigGroupEntity.class).eq(ConfigGroupEntity::getParentGroupId, (Object)groupId));
        this.setGroupIsLeaf(groupId, count == 0L);
    }
}

