/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.manager.plugin.mybatis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.GetConfigInfoDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.ValidateConfigInfoDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.mapper.ConfigInfoMapper;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.ConfigInfoDaoService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarTenantEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.TenantDetails;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.tenant.util.HussarTenantContextHolder;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.convert.ConverterRegistry;
import com.jxdinfo.hussar.support.config.manager.core.enums.OperatorEnum;
import com.jxdinfo.hussar.support.config.manager.core.enums.ValueTypeEnum;
import com.jxdinfo.hussar.support.config.manager.core.util.SetTenantUtil;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigInfoEntity;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.lang.reflect.Type;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
public class ConfigInfoDaoServiceImpl
extends HussarServiceImpl<ConfigInfoMapper, ConfigInfoEntity>
implements ConfigInfoDaoService {
    @Autowired
    private HussarTenantProperties tenantProperties;
    private static final Logger log = LoggerFactory.getLogger(ConfigInfoDaoServiceImpl.class);

    @Override
    public boolean validateConfigKeyExist(ValidateConfigInfoDto validateConfigInfoDto) {
        if (HussarUtils.isEmpty((Object)validateConfigInfoDto) || HussarUtils.isEmpty((Object)validateConfigInfoDto.getOperatorType()) || HussarUtils.isEmpty((Object)validateConfigInfoDto.getGroupPath())) {
            log.info("\u9a8c\u8bc1 configKey \u662f\u5426\u4e3a\u7a7a\u5931\u8d25\uff0c\u4f20\u9012\u53c2\u6570\u4e3a\u7a7a");
            return true;
        }
        LambdaQueryWrapper validateQuery = Wrappers.lambdaQuery();
        validateQuery.eq(HussarUtils.isNotEmpty((Object)validateConfigInfoDto.getConfigKey()), ConfigInfoEntity::getConfigKey, (Object)validateConfigInfoDto.getConfigKey());
        validateQuery.eq(HussarUtils.isNotEmpty((Object)validateConfigInfoDto.getSimpleKey()), ConfigInfoEntity::getSimpleKey, (Object)validateConfigInfoDto.getSimpleKey());
        validateQuery.eq(ConfigInfoEntity::getGroupPath, (Object)validateConfigInfoDto.getGroupPath());
        if (HussarUtils.equals((Object)validateConfigInfoDto.getOperatorType(), (Object)OperatorEnum.OPERATOR_UPDATE.getType())) {
            validateQuery.ne(ConfigInfoEntity::getConfigId, (Object)validateConfigInfoDto.getUpdateConfigInfoId());
        }
        if (HussarUtils.isNotEmpty((Object)validateConfigInfoDto.getTenantCode())) {
            validateQuery.eq(HussarUtils.isNotEmpty((Object)validateConfigInfoDto.getTenantCode()), HussarTenantEntity::getTenantCode, (Object)validateConfigInfoDto.getTenantCode());
        } else if (this.tenantProperties.isEnabled()) {
            TenantDetails tenant = HussarTenantContextHolder.getTenant();
            validateQuery.eq(HussarTenantEntity::getTenantCode, (Object)tenant.getTenantCode());
        }
        long count = this.count((Wrapper)validateQuery);
        return count > 0L;
    }

    @Override
    public List<ConfigInfoEntity> getConfigInfo(GetConfigInfoDto getConfigInfoDto) {
        if (HussarUtils.isEmpty((Object)getConfigInfoDto)) {
            return null;
        }
        ConfigInfoEntity queryConfigInfoEntity = (ConfigInfoEntity)BeanUtil.copyProperties((Object)getConfigInfoDto, ConfigInfoEntity.class);
        if (HussarUtils.isEmpty((Object)queryConfigInfoEntity.getTenantCode())) {
            SetTenantUtil.SetTenantCode((HussarTenantEntity)queryConfigInfoEntity);
        }
        SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
        QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)queryConfigInfoEntity, getConfigInfoDto.getParameterMap());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void validateValueTypeCanCovert(ConfigInfoEntity configInfoEntity) {
        String valueType = configInfoEntity.getValueType();
        ValueTypeEnum enumsByTypeName = ValueTypeEnum.getEnumsByTypeName((String)valueType);
        if (HussarUtils.isEmpty((Object)enumsByTypeName)) {
            throw new HussarException("\u4e0d\u652f\u6301ValueType\u7c7b\u578b[" + valueType + "]");
        }
        try {
            ConverterRegistry instance = ConverterRegistry.getInstance();
            instance.convert((Type)enumsByTypeName.getType(), (Object)configInfoEntity.getConfigValue());
        }
        catch (Exception e) {
            throw new HussarException("\u914d\u7f6e\u9879[" + configInfoEntity.getSimpleKey() + "],\u503c\u7c7b\u578b[" + valueType + "],\u914d\u7f6e\u9879\u503c[" + configInfoEntity.getConfigValue() + "]\u65e0\u6cd5\u8fdb\u884c\u8f6c\u5316");
        }
    }
}

