/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.manager.plugin.mybatis.support.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.GetConfigGroupDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.GetConfigInfoDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.GetGroupTreeDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.GetParentGroupDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.ValidateConfigGroupDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.ConfigGroupDaoService;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.ConfigInfoDaoService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarTenantEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.TenantDetails;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.tenant.util.HussarTenantContextHolder;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.config.manager.core.constants.ConfigConstant;
import com.jxdinfo.hussar.support.config.manager.core.dto.ConfigGroupDto;
import com.jxdinfo.hussar.support.config.manager.core.enums.OperatorEnum;
import com.jxdinfo.hussar.support.config.manager.core.service.HussarConfigGroupService;
import com.jxdinfo.hussar.support.config.manager.core.util.SetTenantUtil;
import com.jxdinfo.hussar.support.config.manager.core.vo.ConfigGroupInfoVo;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigGroupEntity;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigInfoEntity;
import com.jxdinfo.hussar.support.config.manager.vo.ConfigAndGroupVo;
import com.jxdinfo.hussar.support.config.manager.vo.ConfigGroupAndInfoTreeVo;
import com.jxdinfo.hussar.support.config.manager.vo.ConfigGroupTreeVo;
import com.jxdinfo.hussar.support.config.manager.vo.ConfigGroupVo;
import com.jxdinfo.hussar.support.config.manager.vo.ConfigInfoVo;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.query.enums.QueryRuleEnum;
import com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@HussarTransactional
public class HussarConfigGroupServiceImpl
implements HussarConfigGroupService {
    @Autowired
    private HussarTenantProperties hussarTenantProperties;
    @Autowired
    private ConfigGroupDaoService configGroupDaoService;
    @Autowired
    private ConfigInfoDaoService configInfoDaoService;

    public HussarConfigGroupServiceImpl() {
    }

    public HussarConfigGroupServiceImpl(HussarTenantProperties hussarTenantProperties, ConfigGroupDaoService configGroupDaoService) {
        this.hussarTenantProperties = hussarTenantProperties;
        this.configGroupDaoService = configGroupDaoService;
    }

    public HussarConfigGroupServiceImpl(HussarTenantProperties hussarTenantProperties, ConfigGroupDaoService configGroupDaoService, ConfigInfoDaoService configInfoDaoService) {
        this.hussarTenantProperties = hussarTenantProperties;
        this.configGroupDaoService = configGroupDaoService;
        this.configInfoDaoService = configInfoDaoService;
    }

    public void validateConfigGroupDto(ConfigGroupDto configGroupDto, Integer operatorType) {
        boolean exist;
        ValidateConfigGroupDto validateConfigGroupDto = new ValidateConfigGroupDto();
        validateConfigGroupDto.setTenantCode(configGroupDto.getTenantCode());
        validateConfigGroupDto.setGroupCode(configGroupDto.getGroupCode());
        validateConfigGroupDto.setParentGroupId(configGroupDto.getParentGroupId());
        validateConfigGroupDto.setOperatorType(operatorType);
        if (HussarUtils.equals((Object)operatorType, (Object)OperatorEnum.OPERATOR_UPDATE.getType())) {
            validateConfigGroupDto.setUpdateConfigGroupId(configGroupDto.getGroupId());
        }
        if (exist = this.configGroupDaoService.validateGroupCodeExist(validateConfigGroupDto)) {
            throw new HussarException("\u5df2\u7ecf\u5b58\u5728 [" + configGroupDto.getGroupCode() + "] \u5206\u7ec4\u6807\u8bc6");
        }
    }

    @Transactional
    public void saveConfigGroup(ConfigGroupDto configGroupDto) {
        if (HussarUtils.isEmpty((Object)configGroupDto) || HussarUtils.isEmpty((Object)configGroupDto.getGroupCode()) || HussarUtils.isEmpty((Object)configGroupDto.getConfigType()) || HussarUtils.isEmpty((Object)configGroupDto.getGroupName())) {
            throw new HussarException("\u914d\u7f6e\u5206\u7ec4\u6570\u636e\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        if (HussarUtils.isNotEmpty((Object)configGroupDto.getGroupPath())) {
            throw new HussarException("\u914d\u7f6e\u5206\u7ec4\u4e0d\u53ef\u65b0\u589e");
        }
        HussarException.throwBy((boolean)"default".equals(configGroupDto.getGroupCode()), (String)"\u5206\u7ec4code\u4e0d\u53ef\u4f7f\u7528\u7cfb\u7edf\u5173\u952e\u5b57");
        if ((HussarUtils.isEmpty((Object)configGroupDto.getTenantCode()) || HussarUtils.isEmpty((Object)configGroupDto.getTenantId())) && this.hussarTenantProperties.isEnabled()) {
            TenantDetails tenant = HussarTenantContextHolder.getTenant();
            if (HussarUtils.isEmpty((Object)configGroupDto.getTenantCode())) {
                configGroupDto.setTenantCode(tenant.getTenantCode());
                configGroupDto.setTenantId(tenant.getTenantId());
            }
        }
        if (HussarUtils.isEmpty((Object)configGroupDto.getParentGroupId()) || HussarUtils.equals((Object)configGroupDto.getParentGroupId(), (Object)ConfigConstant.defaultParentId)) {
            configGroupDto.setParentGroupId(ConfigConstant.defaultParentId);
            configGroupDto.setGroupPath(configGroupDto.getGroupCode());
        } else {
            ConfigGroupEntity parentGroup = (ConfigGroupEntity)this.configGroupDaoService.getById(configGroupDto.getParentGroupId());
            if (HussarUtils.isEmpty((Object)parentGroup)) {
                throw new HussarException("\u4fdd\u5b58\u7684\u7236\u7ea7\u8282\u70b9\u4e0d\u5b58\u5728,\u4fdd\u5b58\u5931\u8d25");
            }
            if ("default".equals(parentGroup.getGroupPath())) {
                throw new HussarException("\u9ed8\u8ba4\u5206\u7ec4\u5185\u4e0d\u53ef\u6dfb\u52a0\u5b50\u7ea7\u5206\u7ec4");
            }
            String groupPath = parentGroup.getGroupPath();
            groupPath = groupPath + "." + configGroupDto.getGroupCode();
            configGroupDto.setGroupPath(groupPath);
        }
        this.validateConfigGroupDto(configGroupDto, OperatorEnum.OPERATOR_SAVE.getType());
        ConfigGroupEntity configGroupEntity = new ConfigGroupEntity();
        configGroupEntity.setConfigType(configGroupDto.getConfigType());
        configGroupEntity.setGroupCode(configGroupDto.getGroupCode());
        configGroupEntity.setGroupDesc(configGroupDto.getGroupDesc());
        configGroupEntity.setGroupName(configGroupDto.getGroupName());
        configGroupEntity.setTenantCode(configGroupDto.getTenantCode());
        configGroupEntity.setParentGroupId(configGroupDto.getParentGroupId());
        configGroupEntity.setTenantId(configGroupDto.getTenantId());
        configGroupEntity.setGroupPath(configGroupDto.getGroupPath());
        configGroupEntity.setIsLeaf(ConfigConstant.is_leaf);
        this.configGroupDaoService.save(configGroupEntity);
        this.configGroupDaoService.setGroupIsLeaf(configGroupEntity.getParentGroupId(), false);
    }

    @Transactional
    public void updateConfigGroup(ConfigGroupDto configGroupDto) {
        ConfigGroupInfoVo configGroupInfo;
        String updateGroupCode;
        String groupCode;
        String updateParentGroupPath;
        if (HussarUtils.isEmpty((Object)configGroupDto) || HussarUtils.isEmpty((Object)configGroupDto.getGroupCode()) || HussarUtils.isEmpty((Object)configGroupDto.getConfigType()) || HussarUtils.isEmpty((Object)configGroupDto.getGroupName()) || HussarUtils.isEmpty((Object)configGroupDto.getGroupId())) {
            throw new HussarException("\u914d\u7f6e\u5206\u7ec4\u6570\u636e\u4e3a\u7a7a\uff0c\u66f4\u65b0\u5931\u8d25");
        }
        if (HussarUtils.isNotEmpty((Object)configGroupDto.getGroupPath())) {
            throw new HussarException("\u914d\u7f6e\u5206\u7ec4\u4e0d\u53ef\u65b0\u589e");
        }
        this.validateConfigGroupDto(configGroupDto, OperatorEnum.OPERATOR_UPDATE.getType());
        ConfigGroupEntity currentUpdateConfigGroup = (ConfigGroupEntity)this.configGroupDaoService.getById(configGroupDto.getGroupId());
        if (HussarUtils.isEmpty((Object)currentUpdateConfigGroup)) {
            throw new HussarException("\u5f53\u524d\u8282\u70b9\u4fe1\u606f\u672a\u627e\u5230\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        Long parentGroupId = currentUpdateConfigGroup.getParentGroupId();
        Long updateParentGroupId = configGroupDto.getParentGroupId();
        String string = updateParentGroupPath = currentUpdateConfigGroup.getGroupPath().contains(".") ? StringUtil.removeSuffix((CharSequence)currentUpdateConfigGroup.getGroupPath(), (CharSequence)("." + currentUpdateConfigGroup.getGroupCode())) : "";
        if (!HussarUtils.equals((Object)parentGroupId, (Object)updateParentGroupId)) {
            ConfigGroupEntity updateConfigGroup = (ConfigGroupEntity)this.configGroupDaoService.getById(updateParentGroupId);
            if (HussarUtils.isEmpty((Object)updateConfigGroup)) {
                throw new HussarException("\u7236\u8282\u70b9\u4fe1\u606f\u672a\u627e\u5230\uff0c\u64cd\u4f5c\u5931\u8d25");
            }
            ConfigGroupInfoVo configGroupInfo2 = this.getConfigGroupInfo(configGroupDto.getGroupId());
            if (HussarUtils.isNotEmpty((Object)configGroupInfo2.getGroupEntityList()) || HussarUtils.isNotEmpty((Object)configGroupInfo2.getInfoEntityList())) {
                throw new HussarException("\u5f53\u524d\u4fee\u6539\u7684\u8282\u70b9\u4e0b\u5df2\u7ecf\u5b58\u5728\u5176\u4ed6\u5206\u7ec4\u6216\u8005\u914d\u7f6e\u9879\u65e0\u6cd5\u4fee\u6539\uff0c\u5206\u7ec4\u7684\u7236\u8282\u70b9");
            }
            updateParentGroupPath = updateConfigGroup.getGroupPath();
        }
        if (!HussarUtils.equals((Object)(groupCode = currentUpdateConfigGroup.getGroupCode()), (Object)(updateGroupCode = configGroupDto.getGroupCode())) && (HussarUtils.isNotEmpty((Object)(configGroupInfo = this.getConfigGroupInfo(configGroupDto.getGroupId())).getGroupEntityList()) || HussarUtils.isNotEmpty((Object)configGroupInfo.getInfoEntityList()))) {
            throw new HussarException("\u5f53\u524d\u4fee\u6539\u7684\u8282\u70b9\u4e0b\u5df2\u7ecf\u5b58\u5728\u5176\u4ed6\u5206\u7ec4\u6216\u8005\u914d\u7f6e\u9879\u65e0\u6cd5\u4fee\u6539\uff0c\u5206\u7ec4\u7f16\u7801");
        }
        String groupPath = HussarUtils.isNotEmpty((Object)updateParentGroupPath) ? updateParentGroupPath + "." + updateGroupCode : updateGroupCode;
        configGroupDto.setGroupPath(groupPath);
        this.configGroupDaoService.updateById(configGroupDto);
        if (!HussarUtils.equals((Object)parentGroupId, (Object)updateParentGroupId)) {
            this.configGroupDaoService.updateParentIsLeaf(parentGroupId);
            this.configGroupDaoService.setGroupIsLeaf(updateParentGroupId, true);
        }
    }

    public void deleteConfigGroup(List<Long> ids) {
        if (HussarUtils.isEmpty(ids)) {
            return;
        }
        for (Long id : ids) {
            try {
                this.deleteConfigGroup(id);
            }
            catch (Exception exception) {}
        }
    }

    public void deleteConfigGroup(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException("\u53c2\u6570\u4e3a\u7a7a\u5220\u9664\u5931\u8d25");
        }
        ConfigGroupEntity configGroupEntity = (ConfigGroupEntity)this.configGroupDaoService.getById(id);
        if (HussarUtils.isEmpty((Object)configGroupEntity)) {
            return;
        }
        ConfigGroupInfoVo configGroupInfo = this.getConfigGroupInfo(id);
        HussarException.throwBy((boolean)HussarUtils.isNotEmpty((Object)configGroupInfo.getGroupEntityList()), (String)"\u5f53\u524d\u8282\u70b9\u4e0b\u5b58\u5728\u5176\u4ed6\u5206\u7ec4\uff0c\u65e0\u6cd5\u5220\u9664");
        HussarException.throwBy((boolean)HussarUtils.isNotEmpty((Object)configGroupInfo.getInfoEntityList()), (String)"\u5f53\u524d\u8282\u70b9\u4e0b\u5b58\u5728\u5176\u4ed6\u914d\u7f6e\u9879\uff0c\u65e0\u6cd5\u5220\u9664");
        this.configGroupDaoService.removeById(id);
        this.configGroupDaoService.updateParentIsLeaf(configGroupEntity.getParentGroupId());
    }

    public ConfigGroupVo getConfigGroupById(Long groupId) {
        if (HussarUtils.isEmpty((Object)groupId)) {
            return null;
        }
        GetConfigGroupDto getConfigGroupDto = new GetConfigGroupDto();
        getConfigGroupDto.setGroupId(groupId);
        List<ConfigGroupEntity> configGroupList = this.configGroupDaoService.getConfigGroup(getConfigGroupDto);
        if (HussarUtils.isEmpty(configGroupList)) {
            return null;
        }
        ConfigGroupEntity configGroupEntity = configGroupList.get(0);
        ConfigGroupVo configGroupVo = (ConfigGroupVo)BeanUtil.copy((Object)configGroupEntity, ConfigGroupVo.class);
        return configGroupVo;
    }

    public IPage<ConfigGroupEntity> listPage(ConfigGroupDto configGroupDto, Page<ConfigGroupEntity> page, HttpServletRequest req) {
        SetTenantUtil.SetTenantCode((HussarTenantEntity)configGroupDto);
        SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
        QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)configGroupDto, req.getParameterMap());
        IPage pageList = this.configGroupDaoService.page((IPage)page, (Wrapper)queryWrapper);
        return pageList;
    }

    public List<ConfigGroupEntity> list(ConfigGroupDto configGroupDto, HttpServletRequest req) {
        SetTenantUtil.SetTenantCode((HussarTenantEntity)configGroupDto);
        SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
        QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)configGroupDto, req.getParameterMap());
        List list = this.configGroupDaoService.list((Wrapper)queryWrapper);
        return list;
    }

    public ConfigGroupInfoVo getConfigGroupInfo(Long groupId) {
        GetParentGroupDto getParentGroupDto = new GetParentGroupDto();
        getParentGroupDto.setParentId(groupId);
        List<ConfigGroupEntity> parentGroupList = this.configGroupDaoService.getGroupByParentId(getParentGroupDto);
        ConfigGroupEntity groupEntity = (ConfigGroupEntity)this.configGroupDaoService.getById(groupId);
        GetConfigInfoDto getConfigInfoDto = new GetConfigInfoDto();
        getConfigInfoDto.setGroupPath(groupEntity.getGroupPath());
        List<ConfigInfoEntity> configInfoEntityList = this.configInfoDaoService.getConfigInfo(getConfigInfoDto);
        ConfigGroupInfoVo configGroupInfoVo = new ConfigGroupInfoVo();
        configGroupInfoVo.setGroupEntityList(parentGroupList);
        configGroupInfoVo.setInfoEntityList(configInfoEntityList);
        return configGroupInfoVo;
    }

    private List<ConfigGroupTreeVo> getGroupTreeVoByParentId(Long parentId) {
        GetGroupTreeDto getGroupTreeDto = new GetGroupTreeDto();
        getGroupTreeDto.setParentId(parentId);
        return this.configGroupDaoService.getGroupTree(getGroupTreeDto);
    }

    private ConfigGroupTreeVo getGroupTreeVoByGroupId(Long groupId) {
        GetGroupTreeDto getGroupTreeDto = new GetGroupTreeDto();
        getGroupTreeDto.setGroupId(groupId);
        return this.configGroupDaoService.getGroupTree(getGroupTreeDto).get(0);
    }

    public List<ConfigGroupTreeVo> lazyLoadGroupTree(Long parentId) {
        return this.getGroupTreeVoByParentId(parentId);
    }

    public List<ConfigGroupAndInfoTreeVo> lazyLoadGroupAndInfoTree(Long parentId) {
        List<ConfigGroupTreeVo> groupTreeVoByParentId = this.getGroupTreeVoByParentId(parentId);
        ArrayList<ConfigGroupAndInfoTreeVo> result = new ArrayList<ConfigGroupAndInfoTreeVo>();
        if (HussarUtils.isNotEmpty(groupTreeVoByParentId)) {
            List groupTreeVos = BeanUtil.copyProperties(groupTreeVoByParentId, ConfigGroupAndInfoTreeVo.class);
            groupTreeVos.forEach(e -> e.setNodeType("group"));
            result.addAll(groupTreeVos);
        }
        if (!Objects.equals(parentId, ConfigConstant.defaultParentId)) {
            ConfigGroupEntity groupEntity = (ConfigGroupEntity)this.configGroupDaoService.getById(parentId);
            GetConfigInfoDto getConfigInfoDto = new GetConfigInfoDto();
            getConfigInfoDto.setGroupPath(groupEntity.getGroupPath());
            List<ConfigInfoEntity> configInfoEntityList = this.configInfoDaoService.getConfigInfo(getConfigInfoDto);
            if (HussarUtils.isNotEmpty(configInfoEntityList)) {
                List configInfoTreeVos = BeanUtil.copyProperties(configInfoEntityList, ConfigGroupAndInfoTreeVo.class);
                configInfoTreeVos.forEach(e -> e.setNodeType("info"));
                result.addAll(configInfoTreeVos);
            }
        }
        return result;
    }

    public List<ConfigGroupTreeVo> backGroupTree(Long groupId) {
        ConfigGroupTreeVo targetVo = this.getGroupTreeVoByGroupId(groupId);
        ArrayList<ConfigGroupTreeVo> root = new ArrayList<ConfigGroupTreeVo>();
        this.loopGetChildGroupTreeByParentId(targetVo, root);
        return root;
    }

    public void loopGetChildGroupTreeByParentId(ConfigGroupTreeVo brother, List<ConfigGroupTreeVo> root) {
        List<ConfigGroupTreeVo> children = this.getGroupTreeVoByParentId(brother.getParentGroupId());
        for (int i = 0; i < children.size(); ++i) {
            if (!children.get(i).getGroupId().equals(brother.getGroupId())) continue;
            children.set(i, brother);
            break;
        }
        if (brother.getParentGroupId() != ConfigConstant.defaultParentId) {
            ConfigGroupTreeVo parent = this.getGroupTreeVoByGroupId(brother.getParentGroupId());
            parent.setChildren(children);
            this.loopGetChildGroupTreeByParentId(parent, root);
        } else {
            root.addAll(children);
        }
    }

    public List<ConfigGroupVo> listGroupByName(String groupName) {
        GetConfigGroupDto getConfigGroupDto = new GetConfigGroupDto();
        getConfigGroupDto.addParameter("groupName_like", groupName);
        List<ConfigGroupEntity> configGroupEntityList = this.configGroupDaoService.getConfigGroup(getConfigGroupDto);
        List vo = BeanUtil.copyProperties(configGroupEntityList, ConfigGroupVo.class);
        if (HussarUtils.isNotEmpty((Object)vo)) {
            Set parentIds = configGroupEntityList.stream().map(ConfigGroupEntity::getParentGroupId).collect(Collectors.toSet());
            Map<Long, String> map = this.configGroupDaoService.listByIds(parentIds).stream().collect(Collectors.toMap(ConfigGroupEntity::getGroupId, ConfigGroupEntity::getGroupName));
            for (ConfigGroupVo configGroupAndParentNameVo : vo) {
                configGroupAndParentNameVo.setParentName(map.get(configGroupAndParentNameVo.getParentGroupId()));
            }
        }
        return vo;
    }

    public ConfigAndGroupVo listGroupAndInfoByName(String name) {
        ConfigAndGroupVo configAndGroupVo = new ConfigAndGroupVo();
        List<ConfigGroupVo> configGroupAndParentNameVos = this.listGroupByName(name);
        configAndGroupVo.setGroupList(configGroupAndParentNameVos);
        GetConfigInfoDto getConfigInfoDto = new GetConfigInfoDto();
        getConfigInfoDto.addParameter("configName_like", name);
        List<ConfigInfoEntity> configInfo = this.configInfoDaoService.getConfigInfo(getConfigInfoDto);
        if (HussarUtils.isNotEmpty(configInfo)) {
            this.fillGroupName(configInfo);
            List configInfoVos = BeanUtil.copyProperties(configInfo, ConfigInfoVo.class);
            this.fillGroupNamePath(configInfoVos);
            configAndGroupVo.setInfoList(configInfoVos);
        }
        return configAndGroupVo;
    }

    private void fillGroupName(Collection<ConfigInfoEntity> infoEntityList) {
        if (HussarUtils.isNotEmpty(infoEntityList)) {
            Set<String> collect = infoEntityList.stream().map(ConfigInfoEntity::getGroupPath).collect(Collectors.toSet());
            GetConfigGroupDto getConfigGroupDto = new GetConfigGroupDto();
            getConfigGroupDto.addParameter("groupPath" + QueryRuleEnum.IN, collect.toArray(new String[0]));
            Map<String, String> map = this.configGroupDaoService.getConfigGroup(getConfigGroupDto).stream().collect(Collectors.toMap(ConfigGroupEntity::getGroupPath, ConfigGroupEntity::getGroupName));
            infoEntityList.forEach(infoEntity -> infoEntity.setGroupName((String)map.get(infoEntity.getGroupPath())));
        }
    }

    private void fillGroupNamePath(List<ConfigInfoVo> configInfoVos) {
        Set<String> groupPaths = configInfoVos.stream().map(ConfigInfoEntity::getGroupPath).collect(Collectors.toSet());
        HashSet allGroup = new HashSet();
        groupPaths.forEach(groupPath -> allGroup.addAll(this.getAllHierarchyLevels((String)groupPath)));
        GetConfigGroupDto getConfigGroupDto = new GetConfigGroupDto();
        getConfigGroupDto.addParameter("groupPath" + QueryRuleEnum.IN, allGroup.toArray(new String[0]));
        Map<String, String> map = this.configGroupDaoService.getConfigGroup(getConfigGroupDto).stream().collect(Collectors.toMap(ConfigGroupEntity::getGroupPath, ConfigGroupEntity::getGroupName));
        configInfoVos.forEach(configInfoVo -> configInfoVo.setGroupNamePath(this.getGroupNamePath(configInfoVo.getGroupPath(), map)));
    }

    private String getGroupNamePath(String groupPath, Map<String, String> map) {
        ArrayList groupNames = new ArrayList();
        this.getAllHierarchyLevels(groupPath).forEach(level -> groupNames.add(map.get(level)));
        return String.join((CharSequence)"/", groupNames);
    }

    private List<String> getAllHierarchyLevels(String groupPath) {
        String[] parts = groupPath.split("\\.");
        ArrayList<String> levels = new ArrayList<String>();
        for (int i = 0; i < parts.length; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < i + 1; ++j) {
                if (j > 0) {
                    sb.append(".");
                }
                sb.append(parts[j]);
            }
            levels.add(sb.toString());
        }
        return levels;
    }
}

