/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.config.manager.plugin.feign.support;

import com.jxdinfo.hussar.platform.core.utils.ClassUtil;
import com.jxdinfo.hussar.platform.core.utils.convert.ConverterRegistry;
import com.jxdinfo.hussar.support.config.manager.api.HussarConfigApi;
import com.jxdinfo.hussar.support.config.manager.dto.SaveConfigGroupDto;
import com.jxdinfo.hussar.support.config.manager.dto.SaveConfigInfoDto;
import com.jxdinfo.hussar.support.config.manager.dto.UpdateConfigGroupDto;
import com.jxdinfo.hussar.support.config.manager.dto.UpdateConfigInfoDto;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigInfoEntity;
import com.jxdinfo.hussar.support.config.manager.plugin.feign.support.feign.RemoteHussarConfigApi;
import com.jxdinfo.hussar.support.config.manager.vo.ConfigValueVo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HussarConfigApiRemoteImpl
implements HussarConfigApi {
    private static final Logger log = LoggerFactory.getLogger(HussarConfigApiRemoteImpl.class);
    @Autowired
    private RemoteHussarConfigApi remoteHussarConfigApi;

    public String getConfigInfoString(String configKey) {
        return this.remoteHussarConfigApi.getConfigInfoString(configKey);
    }

    public Boolean getConfigInfoBoolean(String configKey) {
        return this.remoteHussarConfigApi.getConfigInfoBoolean(configKey);
    }

    public Integer getConfigInfoInteger(String configKey) {
        return this.remoteHussarConfigApi.getConfigInfoInteger(configKey);
    }

    public <T> T getConfigInfo(Class<T> clz, String configKey) {
        ConfigInfoEntity configInfoEntity = this.remoteHussarConfigApi.getConfigInfo(configKey);
        String valueType = configInfoEntity.getValueType();
        String configValue = configInfoEntity.getConfigValue();
        if (!ClassUtil.equals(clz, (String)valueType, (boolean)true)) {
            throw new RuntimeException("configKey{" + configKey + "}\u5b9a\u4e49\u7684\u503c\u7c7b\u578b{" + valueType + "},\u4e0e\u8bd5\u56fe\u83b7\u53d6\u7684{" + clz.getSimpleName() + "}\u7c7b\u578b\u4e0d\u5339\u914d");
        }
        Object convert = null;
        try {
            ConverterRegistry instance = ConverterRegistry.getInstance();
            convert = instance.convert(clz, (Object)configValue);
        }
        catch (Exception e) {
            log.error("\u6839\u636econfigKey{" + configKey + "},\u83b7\u53d6\u7684\u503c{" + configValue + "},\u8f6c\u5316\u6210{" + clz.getSimpleName() + "}\uff0c\u5931\u8d25");
        }
        return (T)convert;
    }

    public ConfigInfoEntity getConfigInfo(String configKey) {
        return this.remoteHussarConfigApi.getConfigInfo(configKey);
    }

    public List<ConfigValueVo> getConfigByGroupPath(String groupPath) {
        return this.remoteHussarConfigApi.getConfigByGroupPath(groupPath);
    }

    public void saveConfigGroup(SaveConfigGroupDto configGroupDto) {
        this.remoteHussarConfigApi.saveConfigGroup(configGroupDto);
    }

    public void updateConfigGroup(UpdateConfigGroupDto configGroupDto) {
        this.remoteHussarConfigApi.updateConfigGroup(configGroupDto);
    }

    public void saveConfigInfo(SaveConfigInfoDto configInfoDto) {
        this.remoteHussarConfigApi.saveConfigInfo(configInfoDto);
    }

    public void updateConfigInfo(UpdateConfigInfoDto configInfoDto) {
        this.remoteHussarConfigApi.updateConfigInfo(configInfoDto);
    }
}

