/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.aspect;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.aopalliance.aop.Advice;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.StaticMethodMatcher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;

public class AuditLogAnnotationAdvisor
extends AbstractPointcutAdvisor
implements BeanFactoryAware {
    private final Advice advice;
    private final Pointcut pointcut;

    public AuditLogAnnotationAdvisor(Advice advice) {
        this.advice = advice;
        this.pointcut = this.buildPointcut();
    }

    private Pointcut buildPointcut() {
        AnnotationMethodPoint mpc = new AnnotationMethodPoint(AuditLog.class);
        return new ComposablePointcut((Pointcut)mpc);
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.advice instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.advice).setBeanFactory(beanFactory);
        }
    }

    private static class AnnotationMethodPoint
    implements Pointcut {
        private final Class<? extends Annotation> annotationType;

        public AnnotationMethodPoint(Class<? extends Annotation> annotationType) {
            Assert.notNull(annotationType, (String)"Annotation type must not be null");
            this.annotationType = annotationType;
        }

        public ClassFilter getClassFilter() {
            return ClassFilter.TRUE;
        }

        public MethodMatcher getMethodMatcher() {
            return new AnnotationMethodMatcher(this.annotationType);
        }

        private static class AnnotationMethodMatcher
        extends StaticMethodMatcher {
            private final Class<? extends Annotation> annotationType;

            public AnnotationMethodMatcher(Class<? extends Annotation> annotationType) {
                this.annotationType = annotationType;
            }

            public boolean matches(Method method, Class<?> targetClass) {
                if (this.matchesMethod(method, targetClass)) {
                    return true;
                }
                if (Proxy.isProxyClass(targetClass)) {
                    return false;
                }
                Method specificMethod = AopUtils.getMostSpecificMethod((Method)method, targetClass);
                return specificMethod != method && this.matchesMethod(specificMethod, targetClass);
            }

            private boolean matchesMethod(Method method, Class<?> targetClass) {
                Controller controllerAnno = (Controller)AnnotationUtils.findAnnotation(targetClass, Controller.class);
                return HussarUtils.isNotEmpty((Object)controllerAnno) && AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, this.annotationType);
            }
        }
    }
}

