/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.listener;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogColumnEntity;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogEntity;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogTableEntity;
import com.jxdinfo.hussar.support.audit.core.auditlog.service.AuditLogService;
import com.jxdinfo.hussar.support.audit.core.auditlog.vo.AuditLogItemVo;
import com.jxdinfo.hussar.support.audit.core.exception.AuditLogPushException;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeData;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeRowData;
import com.jxdinfo.hussar.support.audit.core.support.event.AuditLogChangeDataEvent;
import com.jxdinfo.hussar.support.audit.core.support.event.AuditLogEvent;
import com.jxdinfo.hussar.support.audit.core.support.event.AuditLogResultEvent;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogErrorSpecialLogUtil;
import com.jxdinfo.hussar.support.thread.config.HussarTpProperties;
import com.jxdinfo.hussar.support.thread.support.executor.HussarTaskExecutor;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;

@EnableAsync
@ConditionalOnProperty(prefix="hussar.audit", name={"enable"}, havingValue="true", matchIfMissing=true)
public class AuditLogSpringListener {
    Logger log = LoggerFactory.getLogger(AuditLogSpringListener.class);
    @Autowired
    private AuditLogService auditLogService;

    @EventListener
    @Async(value="audit_listener_async")
    public void onApplicationEvent(AuditLogEvent event) {
        try {
            AuditLogEntity auditLogEntity = event.getAuditLogEntity();
            if (HussarUtils.isEmpty((Object)auditLogEntity)) {
                return;
            }
            this.auditLogService.save(auditLogEntity);
        }
        catch (Exception e) {
            AuditLogErrorSpecialLogUtil.log((AuditLogEvent)event);
            this.log.error("\u4fdd\u5b58\u5ba1\u8ba1\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
        }
    }

    @EventListener
    @Async(value="audit_listener_async")
    public void onApplicationEvent(AuditLogChangeDataEvent event) {
        try {
            List<AuditLogItemVo> auditLogItemVos = this.doHandlerChangeRowData(event.getAuditLogEntity(), event.getChangeRows());
            if (HussarUtils.isEmpty(auditLogItemVos)) {
                return;
            }
            this.auditLogService.saveAuditLogDataChanges(auditLogItemVos);
        }
        catch (Exception e) {
            AuditLogErrorSpecialLogUtil.log((AuditLogChangeDataEvent)event);
            this.log.error("\u4fdd\u5b58\u5ba1\u8ba1\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
        }
    }

    @EventListener
    @Async(value="audit_listener_async")
    public void onApplicationEvent(AuditLogResultEvent event) {
        try {
            AuditLogEntity auditLogEntity = event.getAuditLogEntity();
            this.auditLogService.udateByCommit(auditLogEntity);
        }
        catch (Exception e) {
            AuditLogErrorSpecialLogUtil.log((AuditLogResultEvent)event);
            this.log.error("\u4fdd\u5b58\u5ba1\u8ba1\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
        }
    }

    @Bean(value={"audit_listener_async"})
    public Executor getAsyncExecutor(HussarTaskExecutor taskExecutor, HussarTpProperties hussarTpProperties) {
        return taskExecutor.createThreadPoolTaskExecutor(hussarTpProperties.getCorePoolSize(), hussarTpProperties.getMaxPoolSize(), hussarTpProperties.getQueueCapacity() * 10, (r, e) -> {
            throw new AuditLogPushException(Integer.valueOf(10002), "queueCapacityOut");
        });
    }

    private List<AuditLogItemVo> doHandlerChangeRowData(AuditLogEntity auditLog, List<ChangeRowData> changeRows) {
        if (HussarUtils.isEmpty((Object)auditLog)) {
            return null;
        }
        if (HussarUtils.isEmpty(changeRows)) {
            return null;
        }
        List changeRowDataFilters = changeRows.stream().filter(changeRowData -> HussarUtils.isNotEmpty((Object)changeRowData.getChangeColumnMap())).collect(Collectors.toList());
        if (HussarUtils.isEmpty(changeRowDataFilters)) {
            return null;
        }
        Long tenantId = auditLog.getTenantId();
        ArrayList<AuditLogItemVo> auditLogItemVos = new ArrayList<AuditLogItemVo>();
        LocalDateTime now = LocalDateTime.now();
        for (ChangeRowData changeRowData2 : changeRowDataFilters) {
            AuditLogItemVo auditLogItemVo = new AuditLogItemVo();
            Set auditLogColumnSet = auditLogItemVo.getAuditLogColumnSet();
            AuditLogTableEntity auditLogTableEntity = new AuditLogTableEntity();
            auditLogTableEntity.setId(null);
            auditLogTableEntity.setTableName(changeRowData2.getTableName());
            auditLogTableEntity.setSchemaName(changeRowData2.getSchemaName());
            auditLogTableEntity.setTableDesc(changeRowData2.getTableDesc());
            auditLogTableEntity.setCommitId(auditLog.getCommitId());
            auditLogTableEntity.setQueryCondition(changeRowData2.getSql());
            auditLogTableEntity.setTenantId(tenantId);
            auditLogTableEntity.setMethodId(changeRowData2.getMapperId());
            auditLogTableEntity.setVersion(auditLog.getVersion());
            auditLogTableEntity.setServerName(auditLog.getServerName());
            auditLogTableEntity.setOperateMode(changeRowData2.getSqlCommandType());
            auditLogTableEntity.setDiffValue(this.getDiffValue(changeRowData2));
            auditLogTableEntity.setCreator(auditLog.getUserId());
            auditLogTableEntity.setCreatorName(auditLog.getCreatorName());
            auditLogTableEntity.setLastEditor(auditLog.getUserId());
            auditLogTableEntity.setLastEditorName(auditLog.getLastEditorName());
            auditLogTableEntity.setCreateTime(now);
            auditLogTableEntity.setLastTime(now);
            Map changeColumnMap = changeRowData2.getChangeColumnMap();
            AuditLogColumnEntity auditLogColumnEntity = null;
            for (Map.Entry entry : changeColumnMap.entrySet()) {
                ChangeData changeData = (ChangeData)entry.getValue();
                auditLogColumnEntity = new AuditLogColumnEntity();
                auditLogColumnEntity.setId(null);
                auditLogColumnEntity.setOperateMode(changeRowData2.getSqlCommandType());
                auditLogColumnEntity.setColumnName((String)entry.getKey());
                auditLogColumnEntity.setColumnDesc(changeData.getName());
                auditLogColumnEntity.setBeforeValue(HussarUtils.isEmpty((Object)changeData.getOldValue()) ? "" : changeData.getOldValue().toString());
                auditLogColumnEntity.setAfterValue(HussarUtils.isEmpty((Object)changeData.getNewValue()) ? "" : changeData.getNewValue().toString());
                auditLogColumnEntity.setCommitId(auditLog.getCommitId());
                auditLogColumnEntity.setTableName(changeRowData2.getTableName());
                auditLogColumnEntity.setTenantId(tenantId);
                auditLogColumnEntity.setCreator(auditLog.getUserId());
                auditLogColumnEntity.setCreatorName(auditLog.getUserName());
                auditLogColumnEntity.setLastEditor(auditLog.getUserId());
                auditLogColumnEntity.setLastEditorName(auditLog.getLastEditorName());
                auditLogColumnEntity.setServerVersion(auditLog.getVersion());
                auditLogColumnEntity.setCreateTime(now);
                auditLogColumnEntity.setLastTime(now);
                auditLogColumnEntity.setAnnotationInfo(HussarUtils.isEmpty((Object)changeData.getAnnotationInfo()) ? "" : changeData.getAnnotationInfo());
                auditLogColumnSet.add(auditLogColumnEntity);
            }
            auditLogItemVo.setAuditLogTable(auditLogTableEntity);
            auditLogItemVo.setAuditLogColumnSet(auditLogColumnSet);
            auditLogItemVos.add(auditLogItemVo);
        }
        return auditLogItemVos;
    }

    private String getDiffValue(ChangeRowData changeRow) {
        if (HussarUtils.isEmpty((Object)changeRow)) {
            return null;
        }
        ArrayList<Map> changeList = new ArrayList<Map>();
        if (HussarUtils.isNotEmpty((Object)changeRow.getChangeColumnMap())) {
            changeList.add(changeRow.getChangeColumnMap());
        }
        return JsonUtil.toJson(changeList);
    }
}

