/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.config;

import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.support.service.TableMetaSupportService;
import com.jxdinfo.hussar.support.audit.aspect.AuditLogAnnotationAdvisor;
import com.jxdinfo.hussar.support.audit.aspect.AuditLogAnnotationInterceptor;
import com.jxdinfo.hussar.support.audit.core.config.AuditLogProperties;
import com.jxdinfo.hussar.support.audit.core.support.listener.AuditLogChangeEventListener;
import com.jxdinfo.hussar.support.audit.plugin.dao.config.AuditLogDaoConfiguration;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.config.DynamicTableAutoConfiguration;
import com.jxdinfo.hussar.support.audit.plugin.mongodb.config.AuditLogMongoConfiguration;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.interceptor.AuditLogMybatisInterceptor;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.listener.MybatisAuditLogEventListener;
import com.jxdinfo.hussar.support.audit.service.DefaultAuditTableMetaSupportService;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@Import(value={AuditLogDaoConfiguration.class, AuditLogMongoConfiguration.class, DynamicTableAutoConfiguration.class})
@ConditionalOnProperty(prefix="hussar.audit", name={"enable"}, havingValue="true", matchIfMissing=true)
public class AuditLogAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditLogAutoConfiguration.class);

    @Bean
    public Advisor auditLogAnnotationAdvisor(AuditLogProperties auditLogProperties, ApplicationEventPublisher applicationEventPublisher, GetLoginUserService getLoginUserService) {
        AuditLogAnnotationInterceptor auditLogAnnotationInterceptor = new AuditLogAnnotationInterceptor(auditLogProperties, applicationEventPublisher, getLoginUserService);
        AuditLogAnnotationAdvisor auditLogAnnotationAdvisor = new AuditLogAnnotationAdvisor((Advice)auditLogAnnotationInterceptor);
        return auditLogAnnotationAdvisor;
    }

    @Bean
    @ConditionalOnMissingBean
    public AuditLogChangeEventListener auditLogChangeEventListener(ApplicationEventPublisher applicationEventPublisher) {
        return new MybatisAuditLogEventListener(applicationEventPublisher);
    }

    @Bean
    @ConditionalOnMissingBean
    public TableMetaSupportService tableMetaSupportService() {
        return new DefaultAuditTableMetaSupportService();
    }

    @Bean
    public AuditLogMybatisInterceptor auditLogMybatisInterceptor(AuditLogChangeEventListener listener, @Autowired(required=false) TableMetaSupportService tableMetaSupportService) {
        return new AuditLogMybatisInterceptor(listener, tableMetaSupportService);
    }
}

