/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.aspect;

import com.jxdinfo.hussar.platform.core.utils.PathUtil;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogEntity;
import com.jxdinfo.hussar.support.audit.core.config.AuditLogProperties;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class AbstractAuditLogAspect {
    public Object aroundExecute(MethodInvocation invocation, AuditLogProperties auditLogProperties) throws Throwable {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        boolean isMatch = PathUtil.pathMatcherUrl((List)auditLogProperties.getExcludeUrlList(), (String)request.getServletPath());
        if (!isMatch) {
            this.doBeforeHandle(request, invocation);
        }
        try {
            Object proceed = invocation.proceed();
            if (!isMatch) {
                this.doAfterHandle();
            }
            return proceed;
        }
        catch (Exception e) {
            if (!isMatch) {
                this.doAfterThrowingHandle(e);
            }
            throw e;
        }
    }

    public abstract void doBeforeHandle(HttpServletRequest var1, MethodInvocation var2);

    public abstract void doAfterHandle();

    public abstract void doAfterThrowingHandle(Throwable var1);

    public abstract AuditLogEntity handleRequestInfo(HttpServletRequest var1, MethodInvocation var2);
}

