/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.interceptor;

import com.jxdinfo.hussar.platform.core.utils.PathUtil;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogEntity;
import com.jxdinfo.hussar.support.audit.core.config.AuditLogProperties;
import com.jxdinfo.hussar.support.audit.core.support.cache.AuditLogThreadLocalCache;
import com.jxdinfo.hussar.support.audit.core.util.AuditUtils;
import com.jxdinfo.hussar.support.audit.interceptor.AbstractAuditLogHandlerInterceptor;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AuditLogHandlerInterceptor
extends AbstractAuditLogHandlerInterceptor
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditLogHandlerInterceptor.class);
    private final AuditLogProperties auditLogProperties;

    public AuditLogHandlerInterceptor(AuditLogProperties auditLogProperties) {
        this.auditLogProperties = auditLogProperties;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        boolean isMatch = PathUtil.pathMatcherUrl((List)this.auditLogProperties.getExcludeUrlList(), (String)request.getServletPath());
        if (isMatch) {
            return true;
        }
        this.doBeforeHandle(request, response, handler);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable ModelAndView modelAndView) throws Exception {
        System.out.println("postHandle");
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        AuditLogThreadLocalCache.remove();
    }

    @Override
    public void doBeforeHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        AuditLogEntity auditLogEntity = this.handleRequestInfo(request, handler);
        auditLogEntity.setCommitId(AuditUtils.getUuid());
        AuditLogThreadLocalCache.set((AuditLogEntity)auditLogEntity);
    }

    @Override
    public void doAfterHandle() {
    }

    @Override
    public void doAfterThrowingHandle(Throwable exception) {
    }
}

