/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.service;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.jxdinfo.hussar.platform.core.annotation.EncryptField;
import com.jxdinfo.hussar.platform.core.annotation.Sensitive;
import com.jxdinfo.hussar.platform.core.enums.SensitiveStrategy;
import com.jxdinfo.hussar.platform.core.support.service.TableMetaSupportService;
import com.jxdinfo.hussar.platform.core.support.service.dto.ColumnMetaInfo;
import com.jxdinfo.hussar.platform.core.support.service.dto.TableMetaInfo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.utils.MybatisUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class AbstractAuditTableMetaSupportService
implements TableMetaSupportService {
    public TableMetaInfo getTableMetaByTableName(String poolName, String tableName) {
        TableMetaInfo tableMetaInfo = new TableMetaInfo();
        TableInfo tableInfo = TableInfoHelper.getTableInfo((String)tableName);
        if (HussarUtils.isEmpty((Object)tableInfo)) {
            return this.customAudit(poolName, tableName);
        }
        Class entityType = tableInfo.getEntityType();
        ApiModel annotation = (ApiModel)AnnotationUtils.findAnnotation((Class)entityType, ApiModel.class);
        tableMetaInfo.setTableName(tableName);
        if (HussarUtils.isNotEmpty((Object)annotation) && HussarUtils.isNotEmpty((Object)annotation.value())) {
            tableMetaInfo.setTableDesc(annotation.value());
        } else {
            tableMetaInfo.setTableDesc(tableName);
        }
        tableMetaInfo.setPoolName(poolName);
        ArrayList<ColumnMetaInfo> columnMetaInfoList = new ArrayList<ColumnMetaInfo>();
        List fieldList = tableInfo.getFieldList();
        fieldList.stream().forEach(tableFieldInfo -> {
            ColumnMetaInfo columnMetaInfo = new ColumnMetaInfo();
            this.fillPropertiesToColumnMetaInfo((TableFieldInfo)tableFieldInfo, columnMetaInfo);
            if (this.validColumnsInfoToTableMetaInfo(columnMetaInfo)) {
                columnMetaInfoList.add(columnMetaInfo);
            }
        });
        Field pkField = MybatisUtils.getPkField((TableInfo)tableInfo);
        if (HussarUtils.isNotEmpty((Object)pkField)) {
            ColumnMetaInfo columnMetaInfo = new ColumnMetaInfo();
            columnMetaInfo.setColumnsName(tableInfo.getKeyColumn());
            columnMetaInfo.setPk(true);
            ApiModelProperty pkFieldAnnotation = pkField.getAnnotation(ApiModelProperty.class);
            if (HussarUtils.isNotEmpty((Object)pkFieldAnnotation)) {
                columnMetaInfo.setColumnsDesc(pkFieldAnnotation.value());
            } else {
                columnMetaInfo.setColumnsDesc("\u4e3b\u952e");
            }
            tableMetaInfo.setPkColumnMetaInfo(columnMetaInfo);
            columnMetaInfoList.add(columnMetaInfo);
        }
        if (HussarUtils.isNotEmpty((Object)tableMetaInfo) && HussarUtils.isNotEmpty((Object)tableMetaInfo.getTableDesc()) && HussarUtils.isNotEmpty(columnMetaInfoList)) {
            tableMetaInfo.setColumnMetaInfoList(columnMetaInfoList);
            return tableMetaInfo;
        }
        return null;
    }

    private boolean validColumnsInfoToTableMetaInfo(ColumnMetaInfo columnMetaInfo) {
        return HussarUtils.isNotEmpty((Object)columnMetaInfo.getColumnsDesc()) || HussarUtils.isNotEmpty((Object)columnMetaInfo.getSensitiveExpression()) || columnMetaInfo.isEnableEncrty();
    }

    private void fillPropertiesToColumnMetaInfo(TableFieldInfo tableFieldInfo, ColumnMetaInfo columnMetaInfo) {
        EncryptField encryptField;
        Sensitive sensitive;
        ApiModelProperty modelProperty = tableFieldInfo.getField().getAnnotation(ApiModelProperty.class);
        columnMetaInfo.setColumnsName(tableFieldInfo.getColumn());
        columnMetaInfo.setPk(false);
        if (HussarUtils.isNotEmpty((Object)modelProperty)) {
            columnMetaInfo.setColumnsDesc(modelProperty.value());
        }
        if (HussarUtils.isNotEmpty((Object)(sensitive = tableFieldInfo.getField().getAnnotation(Sensitive.class)))) {
            columnMetaInfo.setEnableSensitive(true);
            if (HussarUtils.isNotEmpty((Object)sensitive.regex()) && HussarUtils.isNotEmpty((Object)sensitive.replace())) {
                columnMetaInfo.setSensitiveExpression(s -> s.replaceAll(sensitive.regex(), sensitive.replace()));
            } else {
                SensitiveStrategy strategy = sensitive.strategy();
                columnMetaInfo.setSensitiveExpression(strategy.getDesensitizer());
            }
        }
        if (HussarUtils.isNotEmpty((Object)(encryptField = tableFieldInfo.getField().getAnnotation(EncryptField.class)))) {
            columnMetaInfo.setEnableEncrty(true);
        }
    }

    abstract TableMetaInfo customAudit(String var1, String var2);
}

