/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.mybatis.interceptor;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.jxdinfo.hussar.platform.core.support.service.TableMetaSupportService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.config.AuditLogProperties;
import com.jxdinfo.hussar.support.audit.core.support.cache.AuditLogThreadLocalCache;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeRowData;
import com.jxdinfo.hussar.support.audit.core.util.AuditUtils;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.enums.AuditSqlHandlerEnum;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.interceptor.AuditLogMybatisInterceptor;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.support.MybatisInvocation;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.support.sqlhandler.AuditSqlHandler;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.support.sqlhandler.SelectAuditSqlHandler;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.utils.MybatisUtils;
import java.util.List;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Invocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public abstract class AbstractAuditLogInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(AuditLogMybatisInterceptor.class);
    private ClassLoader classLoader;

    public Object auditLogHandler(Invocation invocation, AuditLogProperties auditLogProperties, TableMetaSupportService metaSupportService) throws Throwable {
        boolean isRecord = this.advancePreIsRecord(invocation, auditLogProperties);
        if (!isRecord) {
            return invocation.proceed();
        }
        SelectAuditSqlHandler selectAuditSqlHandler = new SelectAuditSqlHandler(invocation);
        MybatisInvocation mybatisInvocation = selectAuditSqlHandler.createMybatisInvocation(metaSupportService);
        mybatisInvocation.setClassLoader(this.getClassLoader());
        List<ChangeRowData> changeRowDataList = null;
        boolean recordAuditLog = this.isRecordAuditLog(mybatisInvocation);
        if (recordAuditLog) {
            changeRowDataList = this.preDoAuditLogHandler(mybatisInvocation);
        }
        Object result = invocation.proceed();
        if (recordAuditLog) {
            this.postDoAuditLogHandler(mybatisInvocation, changeRowDataList, result);
        }
        return result;
    }

    public abstract List<ChangeRowData> preDoAuditLogHandler(MybatisInvocation var1);

    public abstract void postDoAuditLogHandler(MybatisInvocation var1, List<ChangeRowData> var2, Object var3);

    public abstract boolean isRecordAuditLog(MybatisInvocation var1);

    private boolean advancePreIsRecord(Invocation invocation, AuditLogProperties auditLogProperties) {
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        PluginUtils.MPStatementHandler mpStatementHandler = PluginUtils.mpStatementHandler((StatementHandler)statementHandler);
        BoundSql boundSql = mpStatementHandler.boundSql();
        MappedStatement mappedStatement = mpStatementHandler.mappedStatement();
        String mapperId = mappedStatement.getId();
        return !AuditLogThreadLocalCache.empty() && this.isAuditLogMapper(mapperId, auditLogProperties) && this.isAuditLogTableMapper(boundSql);
    }

    boolean isAuditLogMapper(String mappedId, AuditLogProperties auditLogProperties) {
        if (HussarUtils.isEmpty((Object)auditLogProperties) || HussarUtils.isEmpty((Object)auditLogProperties.getExcludeMappersPattern())) {
            return true;
        }
        AntPathMatcher pathMatcher = new AntPathMatcher(".");
        List excludeMappers = auditLogProperties.getExcludeMappersPattern();
        boolean b = excludeMappers.stream().anyMatch(s -> pathMatcher.matchStart(s, mappedId));
        return !b;
    }

    boolean isAuditLogTableMapper(BoundSql boundSql) {
        try {
            Statement statement = AuditUtils.parseSql((String)boundSql.getSql());
            AuditSqlHandler auditSqlHandler = AuditSqlHandlerEnum.getAuditSqlHandler(statement.getClass());
            if (auditSqlHandler == null) {
                return false;
            }
            Table tableInfo = auditSqlHandler.getTableInfo(statement);
            if (HussarUtils.isEmpty((Object)tableInfo)) {
                return false;
            }
            boolean recordAuditLogByTableName = MybatisUtils.isRecordAuditLogByTableName(tableInfo.getName());
            return recordAuditLogByTableName;
        }
        catch (Exception e) {
            log.error("\u5ba1\u8ba1\u65e5\u5fd7\u8fdb\u884c\u5224\u65ad\u662f\u5426\u9700\u8981\u6392\u9664\u8868\u51fa\u73b0\u5f02\u5e38:{}", (Object)e.getMessage());
            log.error("\u5ba1\u8ba1\u65e5\u5fd7\u8fdb\u884c\u5224\u65ad\u662f\u5426\u9700\u8981\u6392\u9664\u8868\u51fa\u73b0\u5f02\u5e38,\u6267\u884c\u7684sql:{}", (Object)boundSql.getSql());
            return false;
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

