/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.mybatis.handler.impl;

import com.jxdinfo.hussar.platform.core.support.service.dto.ColumnMetaInfo;
import com.jxdinfo.hussar.platform.core.support.service.dto.TableMetaInfo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeColumnData;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeData;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeRowData;
import com.jxdinfo.hussar.support.audit.core.support.dto.PKColumnData;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.handler.AbstractAuditLogParser;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.support.MybatisInvocation;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.utils.MybatisUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateAuditLogParser
extends AbstractAuditLogParser {
    private static final Logger log = LoggerFactory.getLogger(UpdateAuditLogParser.class);

    @Override
    public List<ChangeRowData> parseBefore(MybatisInvocation mybatisInvocation) throws Throwable {
        MappedStatement mappedStatement = mybatisInvocation.getMappedStatement();
        BoundSql boundSql = mybatisInvocation.getBoundSql();
        Method method = MybatisUtils.getMethod(mappedStatement, mybatisInvocation.getClassLoader());
        List<Map<String, Object>> beforeResults = null;
        if (HussarUtils.isEmpty(mybatisInvocation.getColumns())) {
            return new ArrayList<ChangeRowData>();
        }
        try {
            beforeResults = this.query(mybatisInvocation);
        }
        catch (Exception e) {
            log.error("\u5ba1\u8ba1\u65e5\u5fd7\u5728\u6267\u884cUpdateAuditLogParser query \u65f6\u51fa\u9519\uff0cmethod:[{}],sql\u8bed\u53e5:[{}],\u5f02\u5e38\u4fe1\u606f:{}", new Object[]{method.getName(), MybatisUtils.formatSql(boundSql.getSql()), e.getMessage()});
        }
        catch (Throwable throwable) {
            log.error("\u5ba1\u8ba1\u65e5\u5fd7\u5728\u6267\u884cUpdateAuditLogParser query\u65f6\u51fa\u9519\uff0cmethod:[{}],sql\u8bed\u53e5:[{}],\u5f02\u5e38\u4fe1\u606f:{}", new Object[]{method.getName(), MybatisUtils.formatSql(boundSql.getSql()), throwable.getMessage()});
        }
        List<ChangeRowData> changeRows = this.buildChangeDatas(mybatisInvocation, beforeResults);
        return changeRows;
    }

    private List<ChangeRowData> buildChangeDatas(MybatisInvocation mybatisInvocation, List<Map<String, Object>> beforeResults) {
        ArrayList<ChangeRowData> changeRowDatas = new ArrayList<ChangeRowData>();
        List<Map<String, Object>> afterResultList = mybatisInvocation.getColumnsMapList();
        if (HussarUtils.isEmpty(beforeResults) || HussarUtils.isEmpty(afterResultList)) {
            return changeRowDatas;
        }
        for (int index = 0; index < beforeResults.size(); ++index) {
            Map<String, Object> beforeDataMap = beforeResults.get(index);
            Map<String, Object> afterDataMap = afterResultList.get(0);
            ChangeRowData changeRowData = this.buildChangeDataForUpdate(mybatisInvocation, beforeDataMap, afterDataMap);
            changeRowData = this.packageChangeRowData(changeRowData, mybatisInvocation);
            PKColumnData pkColumnData = changeRowData.getPKColumnData();
            Map changeColumnMap = changeRowData.getChangeColumnMap();
            if (HussarUtils.isNotEmpty((Object)pkColumnData) && HussarUtils.isNotEmpty((Object)changeColumnMap)) {
                ChangeData changeData = new ChangeData();
                changeData.setName(pkColumnData.getColumnDes());
                changeData.setNewValue(pkColumnData.getPkVaule());
                changeData.setOldValue(pkColumnData.getPkVaule());
                changeColumnMap.put(pkColumnData.getColumn(), changeData);
            }
            changeRowDatas.add(changeRowData);
        }
        return changeRowDatas;
    }

    private ChangeRowData buildChangeDataForUpdate(MybatisInvocation mybatisInvocation, Map<String, Object> beforeDataMap, Map<String, Object> afterDataMap) {
        ChangeRowData changeData = this.getPkIdAndCreateChangeRowData(mybatisInvocation.getTableMetaInfo(), beforeDataMap);
        List<ChangeColumnData> beforeColumnList = this.dataMapToColumnDataList(mybatisInvocation, beforeDataMap);
        List<ChangeColumnData> afterColumnList = this.dataMapToColumnDataList(mybatisInvocation, afterDataMap);
        changeData.setBeforeColumnList(beforeColumnList);
        changeData.setAfterColumnList(afterColumnList);
        return changeData;
    }

    private ChangeRowData getPkIdAndCreateChangeRowData(TableMetaInfo tableMetaInfo, Map<String, Object> beforeDataMap) {
        ChangeRowData changeRowData = new ChangeRowData();
        if (HussarUtils.isEmpty((Object)tableMetaInfo) || HussarUtils.isEmpty((Object)tableMetaInfo.getPkColumnMetaInfo())) {
            return changeRowData;
        }
        ColumnMetaInfo pkColumnMetaInfo = tableMetaInfo.getPkColumnMetaInfo();
        Optional pkColumnDataOptional = beforeDataMap.entrySet().stream().filter(bdm -> StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)bdm.getKey()), (CharSequence)pkColumnMetaInfo.getColumnsName())).map(bdm -> {
            PKColumnData pkColumnData = new PKColumnData();
            pkColumnData.setColumn((String)bdm.getKey());
            pkColumnData.setPkVaule(bdm.getValue());
            pkColumnData.setColumnDes(pkColumnMetaInfo.getColumnsDesc());
            return pkColumnData;
        }).collect(Collectors.toList()).stream().findFirst();
        if (pkColumnDataOptional.isPresent()) {
            PKColumnData pkColumnData = (PKColumnData)pkColumnDataOptional.get();
            changeRowData.setPKColumnData(pkColumnData);
            beforeDataMap.remove(pkColumnData.getColumn());
        }
        return changeRowData;
    }
}

