/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.mybatis.support.sqlhandler.impl;

import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.jxdinfo.hussar.platform.core.support.service.TableMetaSupportService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.util.DataSourceUtil;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.support.MybatisInvocation;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.support.sqlhandler.AuditSqlHandler;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.sf.jsqlparser.schema.Table;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDmlSqlHandler
implements AuditSqlHandler {
    private static Logger logger = LoggerFactory.getLogger(AbstractDmlSqlHandler.class);

    public void parseTable(MybatisInvocation mybatisInvocation, Table table) {
        MappedStatement mappedStatement = mybatisInvocation.getMappedStatement();
        DataSource dataSource = mappedStatement.getConfiguration().getEnvironment().getDataSource();
        if (HussarUtils.isNotEmpty((Object)table)) {
            mybatisInvocation.setTable(table);
            ItemDataSource itemDataSource = DataSourceUtil.getCurrentItemSource((DataSource)dataSource);
            if (HussarUtils.isNotEmpty((Object)itemDataSource)) {
                String poolName = itemDataSource.getPoolName();
                mybatisInvocation.setSchemaName(poolName);
                TableMetaSupportService tableMetaSupportService = mybatisInvocation.getTableMetaSupportService();
                if (HussarUtils.isNotEmpty((Object)tableMetaSupportService)) {
                    mybatisInvocation.setTableMetaInfo(tableMetaSupportService.getTableMetaByTableName(poolName, table.getName()));
                }
            }
        }
    }

    public void createQueryExecutor(MybatisInvocation mybatisInvocation) {
        Configuration configuration = mybatisInvocation.getConfiguration();
        Environment environment = configuration.getEnvironment();
        Object transactionFactory = environment == null || environment.getTransactionFactory() == null ? new ManagedTransactionFactory() : environment.getTransactionFactory();
        Transaction tx = transactionFactory.newTransaction(environment.getDataSource(), null, true);
        Executor executor = configuration.newExecutor(tx, ExecutorType.SIMPLE);
        mybatisInvocation.setQueryExecutor(executor);
    }

    public void getParamColumnMapping(MybatisInvocation mybatisInvocation, Object object) {
        try {
            MetaObject metaObject = SystemMetaObject.forObject((Object)object);
            Map columnMap = (Map)metaObject.metaObjectForProperty("h").getValue("columnMap");
            mybatisInvocation.setColumnMap(columnMap);
            List columnNames = (List)metaObject.metaObjectForProperty("h").getValue("columnNames");
            mybatisInvocation.setColumnNames(columnNames);
            List columnValues = (List)metaObject.metaObjectForProperty("h").getValue("columnValues");
            mybatisInvocation.setColumnValues(columnValues);
        }
        catch (Exception e) {
            logger.error("MybatisUtils extandMybatisInvocation \u5931\u8d25");
        }
    }

    @Override
    public MybatisInvocation getQueryWhereExpression(MybatisInvocation mybatisInvocation) {
        Object object = mybatisInvocation.getObject();
        if (HussarUtils.isEmpty((Object)object)) {
            return null;
        }
        if (HussarUtils.isEmpty((Object)mybatisInvocation)) {
            return null;
        }
        List<ParameterMapping> parameterMappings = mybatisInvocation.getParameterMappings();
        if (HussarUtils.isEmpty(parameterMappings)) {
            return null;
        }
        this.getParamColumnMapping(mybatisInvocation, object);
        List<Object> columnValues = mybatisInvocation.getColumnValues();
        if (HussarUtils.isEmpty(columnValues)) {
            return null;
        }
        return mybatisInvocation;
    }
}

