/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.mybatis.support.sqlhandler;

import com.jxdinfo.hussar.platform.core.support.service.TableMetaSupportService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.util.AuditUtils;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.enums.AuditSqlHandlerEnum;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.support.MybatisInvocation;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.support.sqlhandler.AuditSqlHandler;
import java.util.List;
import net.sf.jsqlparser.statement.Statement;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectAuditSqlHandler {
    private static Logger logger = LoggerFactory.getLogger(SelectAuditSqlHandler.class);
    private Invocation invocation;

    public MybatisInvocation createMybatisInvocation(TableMetaSupportService metaSupportService) {
        MybatisInvocation mybatisInvocation = new MybatisInvocation(this.invocation);
        mybatisInvocation.setTableMetaSupportService(metaSupportService);
        BoundSql boundSql = mybatisInvocation.getBoundSql();
        MetaObject moBoundSql = SystemMetaObject.forObject((Object)boundSql);
        String sql = moBoundSql.getValue("sql").toString();
        List parameterMappings = (List)moBoundSql.getValue("parameterMappings");
        mybatisInvocation.setParameterMappings(parameterMappings);
        try {
            Statement statement = AuditUtils.parseSql((String)sql);
            AuditSqlHandler auditSqlHandler = AuditSqlHandlerEnum.getAuditSqlHandler(statement.getClass());
            if (HussarUtils.isEmpty((Object)auditSqlHandler)) {
                return null;
            }
            return auditSqlHandler.parseSql(statement, mybatisInvocation);
        }
        catch (Exception e) {
            logger.error("\u5ba1\u8ba1\u65e5\u5fd7\u8f6c\u5316\u5931\u8d25\uff0c" + mybatisInvocation.getMappedStatement().getId() + "\u8f6c\u5316\u5931\u8d25");
            return null;
        }
    }

    public SelectAuditSqlHandler(Invocation invocation) {
        this.invocation = invocation;
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    public void setInvocation(Invocation invocation) {
        this.invocation = invocation;
    }
}

