/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.mybatis.interceptor;

import com.jxdinfo.hussar.platform.core.support.service.TableMetaSupportService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLogIgnore;
import com.jxdinfo.hussar.support.audit.core.config.AuditLogProperties;
import com.jxdinfo.hussar.support.audit.core.support.cache.AuditLogThreadLocalCache;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeRowData;
import com.jxdinfo.hussar.support.audit.core.support.listener.AuditLogChangeEventListener;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.handler.AuditLogParser;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.interceptor.AbstractAuditLogInterceptor;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.support.MybatisInvocation;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.utils.MybatisUtils;
import java.lang.reflect.Method;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Intercepts(value={@Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="batch", args={Statement.class})})
public class AuditLogMybatisInterceptor
extends AbstractAuditLogInterceptor {
    private static Logger log = LoggerFactory.getLogger(AuditLogMybatisInterceptor.class);
    private AuditLogChangeEventListener listener;
    @Autowired
    private AuditLogProperties auditLogProperties;
    private Properties properties;
    private TableMetaSupportService metaSupportService;

    public AuditLogMybatisInterceptor(AuditLogChangeEventListener listener) {
        this.listener = listener;
    }

    public AuditLogMybatisInterceptor(AuditLogChangeEventListener listener, TableMetaSupportService metaSupportService) {
        this.listener = listener;
        this.metaSupportService = metaSupportService;
    }

    public AuditLogMybatisInterceptor(AuditLogChangeEventListener listener, TableMetaSupportService metaSupportService, ClassLoader classLoader) {
        this.listener = listener;
        this.metaSupportService = metaSupportService;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object result = this.auditLogHandler(invocation, this.auditLogProperties, this.metaSupportService);
        return result;
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public List<ChangeRowData> preDoAuditLogHandler(MybatisInvocation mybatisInvocation) {
        List<ChangeRowData> changeRows = null;
        AuditLogParser auditLogParser = mybatisInvocation.getAuditLogParser();
        MappedStatement mappedStatement = mybatisInvocation.getMappedStatement();
        BoundSql boundSql = mybatisInvocation.getBoundSql();
        Method method = MybatisUtils.getMethod(mappedStatement, mybatisInvocation.getClassLoader());
        try {
            if (HussarUtils.isEmpty((Object)auditLogParser)) {
                return null;
            }
            changeRows = auditLogParser.parseBefore(mybatisInvocation);
            return changeRows;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5ba1\u8ba1\u65e5\u5fd7\u5728\u6267\u884cpreDoAuditLogHandler\u65f6\u51fa\u9519\uff0cmethod:[{}],sql\u8bed\u53e5:[{}]", (Object)method.getName(), (Object)boundSql.getSql());
        }
        catch (Throwable throwable) {
            log.error("\u5ba1\u8ba1\u65e5\u5fd7\u5728\u6267\u884cpreDoAuditLogHandler\u65f6\u51fa\u9519\uff0cmethod:[{}],sql\u8bed\u53e5:[{}]", (Object)method.getName(), (Object)boundSql.getSql());
            throwable.printStackTrace();
        }
        return changeRows;
    }

    @Override
    public void postDoAuditLogHandler(MybatisInvocation mybatisInvocation, List<ChangeRowData> changeRows, Object result) {
        MappedStatement mappedStatement = mybatisInvocation.getMappedStatement();
        BoundSql boundSql = mybatisInvocation.getBoundSql();
        Method method = MybatisUtils.getMethod(mappedStatement, mybatisInvocation.getClassLoader());
        AuditLogParser auditLogParser = mybatisInvocation.getAuditLogParser();
        try {
            changeRows = auditLogParser.parseAfter(mybatisInvocation, changeRows);
            auditLogParser.sendData(this.listener, mybatisInvocation.getSqlCommandType().name(), changeRows);
        }
        catch (Exception e) {
            log.error("\u5ba1\u8ba1\u65e5\u5fd7\u5728\u6267\u884cpostDoAuditLogHandler\u65f6\u51fa\u9519\uff0cmethod:[{}],sql\u8bed\u53e5:[{}],\u5f02\u5e38\u4fe1\u606f:{}", new Object[]{method.getName(), MybatisUtils.formatSql(boundSql.getSql()), e.getMessage()});
        }
        catch (Throwable throwable) {
            log.error("\u5ba1\u8ba1\u65e5\u5fd7\u5728\u6267\u884cpostDoAuditLogHandler\u65f6\u51fa\u9519\uff0cmethod:[{}],sql\u8bed\u53e5:[{}],\u5f02\u5e38\u4fe1\u606f:{}", new Object[]{method.getName(), MybatisUtils.formatSql(boundSql.getSql()), throwable.getMessage()});
        }
    }

    @Override
    public boolean isRecordAuditLog(MybatisInvocation mybatisInvocation) {
        boolean empty = AuditLogThreadLocalCache.empty();
        if (empty) {
            return false;
        }
        if (HussarUtils.isEmpty((Object)mybatisInvocation) || HussarUtils.isEmpty((Object)mybatisInvocation.getTable())) {
            return false;
        }
        AuditLogParser auditLogParser = mybatisInvocation.getAuditLogParser();
        if (HussarUtils.isEmpty((Object)auditLogParser)) {
            return false;
        }
        MappedStatement mappedStatement = mybatisInvocation.getMappedStatement();
        if (HussarUtils.isEmpty((Object)mappedStatement)) {
            return false;
        }
        String mappedStatementId = mappedStatement.getId();
        boolean auditLogMapper = this.isAuditLogMapper(mappedStatementId, this.auditLogProperties);
        if (!auditLogMapper) {
            return false;
        }
        AuditLogIgnore annotation = MybatisUtils.getAnnotation(mybatisInvocation.getMappedStatement(), AuditLogIgnore.class, mybatisInvocation.getClassLoader());
        if (HussarUtils.isNotEmpty((Object)annotation)) {
            return false;
        }
        boolean recordAuditLogByTableName = MybatisUtils.isRecordAuditLogByTableName(mybatisInvocation.getTable().getName());
        return recordAuditLogByTableName;
    }

    public AuditLogChangeEventListener getListener() {
        return this.listener;
    }

    public AuditLogProperties getAuditLogProperties() {
        return this.auditLogProperties;
    }

    public TableMetaSupportService getMetaSupportService() {
        return this.metaSupportService;
    }

    public void setAuditLogProperties(AuditLogProperties auditLogProperties) {
        this.auditLogProperties = auditLogProperties;
    }
}

