/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.mybatis.handler.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeColumnData;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeRowData;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.handler.AbstractAuditLogParser;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.support.MybatisInvocation;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.utils.MybatisUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteAuditLogParser
extends AbstractAuditLogParser {
    private static Logger log = LoggerFactory.getLogger(AbstractAuditLogParser.class);

    @Override
    public List<ChangeRowData> parseBefore(MybatisInvocation mybatisInvocation) throws Throwable {
        MappedStatement mappedStatement = mybatisInvocation.getMappedStatement();
        BoundSql boundSql = mybatisInvocation.getBoundSql();
        Method method = MybatisUtils.getMethod(mappedStatement, mybatisInvocation.getClassLoader());
        List<Map<String, Object>> beforeResults = null;
        try {
            beforeResults = this.query(mybatisInvocation);
        }
        catch (Exception e) {
            log.error("\u5ba1\u8ba1\u65e5\u5fd7\u5728\u6267\u884c DeleteAuditLogParser query \u65f6\u51fa\u9519\uff0cmethod:[{}],sql\u8bed\u53e5:[{}],\u5f02\u5e38\u4fe1\u606f:{}", new Object[]{method.getName(), MybatisUtils.formatSql(boundSql.getSql()), e.getMessage()});
        }
        catch (Throwable throwable) {
            log.error("\u5ba1\u8ba1\u65e5\u5fd7\u5728\u6267\u884c DeleteAuditLogParser query \u65f6\u51fa\u9519\uff0cmethod:[{}],sql\u8bed\u53e5:[{}],\u5f02\u5e38\u4fe1\u606f:{}", new Object[]{method.getName(), MybatisUtils.formatSql(boundSql.getSql()), throwable.getMessage()});
        }
        List<ChangeRowData> results = this.buildChangeDatas(mybatisInvocation, beforeResults);
        return results;
    }

    private List<ChangeRowData> buildChangeDatas(MybatisInvocation mybatisInvocation, List<Map<String, Object>> beforeResults) {
        ArrayList<ChangeRowData> changeRowDatas = new ArrayList<ChangeRowData>();
        if (HussarUtils.isEmpty(beforeResults)) {
            return changeRowDatas;
        }
        for (Map<String, Object> beforeDataMap : beforeResults) {
            ChangeRowData changeRowData = this.buildChangeDataForDelete(mybatisInvocation, beforeDataMap);
            changeRowDatas.add(this.packageChangeRowData(changeRowData, mybatisInvocation));
        }
        return changeRowDatas;
    }

    private ChangeRowData buildChangeDataForDelete(MybatisInvocation mybatisInvocation, Map<String, Object> beforeDataMap) {
        List<ChangeColumnData> columnList = this.dataMapToColumnDataList(mybatisInvocation, beforeDataMap);
        ChangeRowData changeData = new ChangeRowData();
        changeData.setBeforeColumnList(columnList);
        return changeData;
    }
}

