/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.mybatis.handler;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.config.HussarCoreProperties;
import com.jxdinfo.hussar.platform.core.support.service.dto.ColumnMetaInfo;
import com.jxdinfo.hussar.platform.core.support.service.dto.TableMetaInfo;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeColumnData;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeData;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeRowData;
import com.jxdinfo.hussar.support.audit.core.support.listener.AuditLogChangeEventListener;
import com.jxdinfo.hussar.support.audit.core.util.JsqlParserUtil;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.handler.AuditLogParser;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.support.MybatisInvocation;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.support.dto.CompareDataDto;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.utils.MybatisUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.Select;
import oracle.sql.TIMESTAMP;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public abstract class AbstractAuditLogParser
implements AuditLogParser {
    private static Logger logger = LoggerFactory.getLogger(AbstractAuditLogParser.class);

    @Override
    public List<Map<String, Object>> query(MybatisInvocation mybatisInvocation) throws SQLException {
        List queryResultList;
        List<ParameterMapping> whereParamterMapping;
        Table table = mybatisInvocation.getTable();
        MappedStatement mappedStatement = mybatisInvocation.getMappedStatement();
        ArrayList<Column> updateColumns = new ArrayList<Column>();
        if (mybatisInvocation.getSqlCommandType() == SqlCommandType.UPDATE) {
            updateColumns.addAll(mybatisInvocation.getColumns());
            this.addPkColumn(updateColumns, mybatisInvocation);
            whereParamterMapping = mybatisInvocation.getWhereParameterMappings();
        } else {
            Column column = new Column();
            column.setColumnName("*");
            updateColumns.add(column);
            whereParamterMapping = mybatisInvocation.getParameterMappings();
        }
        Expression whereExpression = mybatisInvocation.getWhereExpression();
        if (HussarUtils.isEmpty((Object)whereExpression)) {
            logger.warn("\u5ba1\u8ba1\u65e5\u5fd7sql\u8bed\u53e5\u6ca1\u6709where\u6761\u4ef6\uff0c\u4e0d\u8fdb\u884c\u8bb0\u5f55\u65e5\u5fd7");
            return null;
        }
        Select select = JsqlParserUtil.getSelect((Table)table, updateColumns, (Expression)whereExpression);
        MappedStatement selectMappedStatement = MybatisUtils.newHashMapMappedStatement(mappedStatement);
        BoundSql queryBoundSql = selectMappedStatement.getBoundSql(mybatisInvocation.getParameterObject());
        MybatisUtils.setQuerySql(queryBoundSql, select.toString());
        MybatisUtils.setParameterMappings(queryBoundSql, whereParamterMapping);
        Executor queryExecutor = mybatisInvocation.getQueryExecutor();
        List queryResults = queryResultList = queryExecutor.query(selectMappedStatement, mybatisInvocation.getParameterObject(), RowBounds.DEFAULT, Executor.NO_RESULT_HANDLER, null, queryBoundSql);
        logger.debug("***************************************************************************");
        logger.debug("*************************" + queryExecutor.isClosed() + "**************************************************");
        if (!queryExecutor.isClosed()) {
            queryExecutor.close(true);
        }
        logger.debug("*************************" + queryExecutor.isClosed() + "**************************************************");
        logger.debug("***************************************************************************");
        return queryResults;
    }

    @Override
    public void sendData(AuditLogChangeEventListener listener, String commandName, List<ChangeRowData> changeRows) {
        if (HussarUtils.isEmpty(changeRows)) {
            return;
        }
        if (HussarUtils.isEmpty((Object)listener)) {
            logger.debug("\u5ba1\u8ba1\u65e5\u5fd7\u53d8\u5316\u7684\u6570\u636e\uff1a" + changeRows);
        }
        if (SqlCommandType.UPDATE.name().equalsIgnoreCase(commandName)) {
            listener.onUpdate(changeRows);
        } else if (SqlCommandType.INSERT.name().equalsIgnoreCase(commandName)) {
            listener.onInsert(changeRows);
        } else if (SqlCommandType.DELETE.name().equalsIgnoreCase(commandName)) {
            listener.onDelete(changeRows);
        }
    }

    @Override
    public List<ChangeRowData> parseAfter(MybatisInvocation mybatisInvocation, List<ChangeRowData> changeRows) {
        if (HussarUtils.isEmpty(changeRows)) {
            return null;
        }
        return changeRows;
    }

    @Override
    public Map<String, ChangeData> doCreateChangeDataMap(ChangeRowData changeRowData) {
        if (HussarUtils.isEmpty((Object)changeRowData)) {
            return null;
        }
        List afterColumnList = changeRowData.getAfterColumnList();
        List beforeColumnList = changeRowData.getBeforeColumnList();
        if (HussarUtils.isEmpty((Object)afterColumnList) && HussarUtils.isEmpty((Object)beforeColumnList)) {
            return null;
        }
        HashMap<String, ChangeData> map = new HashMap<String, ChangeData>();
        if (HussarUtils.isNotEmpty((Object)afterColumnList)) {
            return this.getChangeDataMap(afterColumnList, beforeColumnList, map);
        }
        return this.getChangeDataMap(beforeColumnList, map);
    }

    protected List<ChangeColumnData> dataMapToColumnDataList(MybatisInvocation mybatisInvocation, Map<String, Object> dataMap) {
        ArrayList<ChangeColumnData> columnList = new ArrayList<ChangeColumnData>();
        if (HussarUtils.isEmpty(dataMap)) {
            return columnList;
        }
        TableMetaInfo tableMetaInfo = mybatisInvocation.getTableMetaInfo();
        for (Map.Entry<String, Object> dataEntry : dataMap.entrySet()) {
            boolean recordAuditLogByColumnName = MybatisUtils.isRecordAuditLogByColumnName(mybatisInvocation.getTable().getName(), dataEntry.getKey());
            if (!recordAuditLogByColumnName) continue;
            ChangeColumnData changeColumn = new ChangeColumnData();
            changeColumn.setName(dataEntry.getKey());
            changeColumn.setValue(dataEntry.getValue());
            if (HussarUtils.isEmpty((Object)tableMetaInfo)) {
                changeColumn.setNameDesc(dataEntry.getKey());
            } else {
                ColumnMetaInfo columsMetaInfo = tableMetaInfo.getColumsByColName(dataEntry.getKey());
                if (HussarUtils.isNotEmpty((Object)columsMetaInfo) && HussarUtils.isNotEmpty((Object)columsMetaInfo.getColumnsDesc())) {
                    ColumnMetaInfo columsByColName = tableMetaInfo.getColumsByColName(dataEntry.getKey());
                    changeColumn.setNameDesc(columsByColName.getColumnsDesc());
                } else {
                    changeColumn.setNameDesc(dataEntry.getKey());
                }
            }
            columnList.add(changeColumn);
        }
        return columnList;
    }

    protected ChangeRowData packageChangeRowData(ChangeRowData changeRowData, MybatisInvocation mybatisInvocation) {
        changeRowData.setSchemaName(mybatisInvocation.getSchemaName());
        changeRowData.setTableName(mybatisInvocation.getTable().getName());
        changeRowData.setSql(mybatisInvocation.getSql());
        changeRowData.setMapperId(mybatisInvocation.getMappedStatement().getId());
        Map<String, ChangeData> changeDataMap = this.doCreateChangeDataMap(changeRowData);
        changeRowData.setChangeColumnMap(changeDataMap);
        changeRowData.setSqlCommandType(mybatisInvocation.getSqlCommandType().name());
        TableMetaInfo tableMetaInfo = mybatisInvocation.getTableMetaInfo();
        if (HussarUtils.isNotEmpty((Object)tableMetaInfo)) {
            changeRowData.setTableDesc(tableMetaInfo.getTableDesc());
        } else {
            changeRowData.setTableDesc(mybatisInvocation.getTable().getName());
        }
        this.sensitiveAuditColumns(mybatisInvocation, changeDataMap);
        this.appendAnnoForAuditColumns(mybatisInvocation, changeDataMap);
        return changeRowData;
    }

    private Object dataFormat(Object value, Class type) {
        if (HussarUtils.isEmpty((Object)value)) {
            return "";
        }
        if (value instanceof TIMESTAMP) {
            TIMESTAMP timestamp = (TIMESTAMP)value;
            try {
                value = timestamp.toLocalDateTime();
            }
            catch (SQLException sqlException) {
                value = null;
            }
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)value;
            ldt = ldt.withNano(0);
            return DateUtil.DATETIME_FORMAT.format((Date)Timestamp.valueOf(ldt));
        }
        if (HussarUtils.equals(Boolean.class, (Object)type) && !(value instanceof Boolean)) {
            return this.dataFormatToBoolean(value);
        }
        return value;
    }

    private Map<String, ChangeData> getChangeDataMap(List<ChangeColumnData> beforeColumnList, Map<String, ChangeData> map) {
        if (HussarUtils.isEmpty(map)) {
            map = new HashMap<String, ChangeData>();
        }
        for (ChangeColumnData before : beforeColumnList) {
            String name = before.getName();
            Object value = before.getValue();
            if (!HussarUtils.isNotEmpty((Object)(value = this.dataFormat(value, null)))) continue;
            map.put(name, new ChangeData(before.getNameDesc(), value, null));
        }
        return map;
    }

    private Map<String, ChangeData> getChangeDataMap(List<ChangeColumnData> afterColumnList, List<ChangeColumnData> beforeColumnList, Map<String, ChangeData> map) {
        if (HussarUtils.isEmpty(map)) {
            map = new HashMap<String, ChangeData>();
        }
        if (HussarUtils.isEmpty(beforeColumnList)) {
            beforeColumnList = new ArrayList<ChangeColumnData>();
        }
        for (int i = 0; i < afterColumnList.size(); ++i) {
            Object beforeValue;
            String afterName;
            ChangeColumnData afterChangeData = afterColumnList.get(i);
            String finalName = afterName = afterChangeData.getName();
            Optional<ChangeColumnData> first = beforeColumnList.stream().filter(cd -> StringUtil.equalsIgnoreCase((CharSequence)cd.getName(), (CharSequence)finalName)).findFirst();
            if (first.isPresent()) {
                ChangeColumnData beforeChangeData = first.get();
                beforeValue = beforeChangeData.getValue();
            } else {
                beforeValue = null;
            }
            Object afterValue = afterChangeData.getValue();
            Class<?> type = this.getClassType(beforeValue, afterValue);
            if (HussarUtils.isEmpty(type)) continue;
            CompareDataDto compareDataDto = new CompareDataDto(beforeValue, afterValue, afterName, afterChangeData.getNameDesc(), type);
            if (HussarUtils.isEmpty((Object)(compareDataDto = this.doDataCompare(compareDataDto))) || compareDataDto.isCompare()) continue;
            map.put(compareDataDto.getColumnName(), new ChangeData(compareDataDto.getColumnDesc(), compareDataDto.getBeforeValue(), compareDataDto.getAfterValue()));
        }
        return map;
    }

    private CompareDataDto doDataCompare(CompareDataDto compareDataDto) {
        if (HussarUtils.isEmpty((Object)compareDataDto)) {
            return null;
        }
        Class type = compareDataDto.getType();
        Object afterValue = HussarUtils.isEmpty((Object)compareDataDto.getAfterValue()) ? "" : compareDataDto.getAfterValue();
        Object beforeValue = HussarUtils.isEmpty((Object)compareDataDto.getBeforeValue()) ? "" : compareDataDto.getBeforeValue();
        afterValue = this.dataFormat(afterValue, type);
        beforeValue = this.dataFormat(beforeValue, type);
        compareDataDto.setAfterValue(afterValue);
        compareDataDto.setBeforeValue(beforeValue);
        compareDataDto.setCompare(this.compareValue(afterValue, beforeValue));
        return compareDataDto;
    }

    private boolean compareValue(Object afterValue, Object beforeValue) {
        if (afterValue instanceof Number && beforeValue instanceof Number) {
            return HussarUtils.equals((Object)((Number)afterValue).doubleValue(), (Object)((Number)beforeValue).doubleValue());
        }
        return HussarUtils.equals((Object)afterValue, (Object)beforeValue);
    }

    private Object dataFormatToBoolean(Object value) {
        if (value instanceof Number) {
            return HussarUtils.equals((Object)((Number)value).intValue(), (Object)1);
        }
        if (value instanceof String) {
            return HussarUtils.equals((Object)"1", (Object)value.toString());
        }
        if (value instanceof byte[]) {
            return HussarUtils.equals((Object)"1", (Object)new String((byte[])value));
        }
        return value;
    }

    private Class<?> getClassType(Object beforeValue, Object afterValue) {
        if (afterValue != null) {
            return afterValue.getClass();
        }
        if (beforeValue != null) {
            return beforeValue.getClass();
        }
        return null;
    }

    private void sensitiveAuditColumns(MybatisInvocation mybatisInvocation, Map<String, ChangeData> changeDataMap) {
        if (HussarUtils.isEmpty(changeDataMap)) {
            return;
        }
        TableMetaInfo tableMetaInfo = mybatisInvocation.getTableMetaInfo();
        if (HussarUtils.isEmpty((Object)tableMetaInfo) || HussarUtils.isEmpty((Object)tableMetaInfo.getColumnMetaInfoList())) {
            return;
        }
        changeDataMap.keySet().stream().forEach(key -> {
            ChangeData changeData = (ChangeData)changeDataMap.get(key);
            ColumnMetaInfo columsByColName = tableMetaInfo.getColumsByColName(key);
            if (HussarUtils.isEmpty((Object)columsByColName)) {
                return;
            }
            try {
                Function sensitiveExpression = columsByColName.getSensitiveExpression();
                if (!columsByColName.isEnableEncrty() && columsByColName.isEnableSensitive() && HussarUtils.isNotEmpty((Object)sensitiveExpression)) {
                    if (HussarUtils.isNotEmpty((Object)changeData.getOldValue()) && String.class.isAssignableFrom(changeData.getOldValue().getClass())) {
                        changeData.setOldValue(sensitiveExpression.apply((String)changeData.getOldValue()));
                    }
                    if (HussarUtils.isNotEmpty((Object)changeData.getNewValue()) && String.class.isAssignableFrom(changeData.getNewValue().getClass())) {
                        changeData.setNewValue(sensitiveExpression.apply((String)changeData.getNewValue()));
                    }
                }
            }
            catch (Exception e) {
                logger.warn("\u5ba1\u8ba1\u65e5\u5fd7\u5728\u8fdb\u884c\u5904\u7406\u8131\u654f\u51fa\u9519\u4e86");
            }
        });
    }

    protected void appendAnnoForAuditColumns(MybatisInvocation mybatisInvocation, Map<String, ChangeData> changeDataMap) {
        if (HussarUtils.isEmpty(changeDataMap)) {
            return;
        }
        TableMetaInfo tableMetaInfo = mybatisInvocation.getTableMetaInfo();
        if (HussarUtils.isEmpty((Object)tableMetaInfo) || HussarUtils.isEmpty((Object)tableMetaInfo.getColumnMetaInfoList())) {
            return;
        }
        changeDataMap.keySet().stream().forEach(key -> {
            ChangeData changeData = (ChangeData)changeDataMap.get(key);
            ColumnMetaInfo columsByColName = tableMetaInfo.getColumsByColName(key);
            if (HussarUtils.isEmpty((Object)columsByColName)) {
                return;
            }
            try {
                Object transInfo = columsByColName.getAnnotationInfo();
                HashMap<String, Object> annoMap = new HashMap<String, Object>();
                if (!HussarUtils.isEmpty((Object)transInfo)) {
                    annoMap.put("transInfo", transInfo);
                    if (((HussarCoreProperties)SpringContextUtil.getBean(HussarCoreProperties.class)).isEnableMicroService()) {
                        String serviceName = ((Environment)SpringContextUtil.getBean(Environment.class)).getProperty("spring.application.name");
                        annoMap.put("serviceName", serviceName);
                    }
                }
                if (columsByColName.isEnableEncrty()) {
                    annoMap.put("isEncrypt", true);
                }
                if (HussarUtils.isNotEmpty(annoMap)) {
                    changeData.setAnnotationInfo(JSON.toJSONString(annoMap));
                }
            }
            catch (Exception e) {
                logger.warn("\u5ba1\u8ba1\u65e5\u5fd7\u5728\u8bb0\u5f55\u6ce8\u89e3\u4fe1\u606f\u65f6\u51fa\u9519\u4e86\uff0c{}", (Object)e.getMessage());
            }
        });
    }

    private void addPkColumn(List<Column> updateColumns, MybatisInvocation mybatisInvocation) {
        TableMetaInfo tableMetaInfo = mybatisInvocation.getTableMetaInfo();
        if (HussarUtils.isNotEmpty((Object)tableMetaInfo) && HussarUtils.isNotEmpty((Object)tableMetaInfo.getPkColumnMetaInfo())) {
            ColumnMetaInfo pkColumnMetaInfo = tableMetaInfo.getPkColumnMetaInfo();
            Optional<Column> first = updateColumns.stream().filter(uc -> uc.getColumnName().equalsIgnoreCase(pkColumnMetaInfo.getColumnsName())).findFirst();
            if (!first.isPresent()) {
                Column column = new Column();
                column.setColumnName(pkColumnMetaInfo.getColumnsName());
                updateColumns.add(column);
            }
        }
    }
}

