/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.mongodb.support.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogColumnEntity;
import com.jxdinfo.hussar.support.audit.core.auditlog.service.AuditColumnCURDService;
import com.jxdinfo.hussar.support.audit.plugin.mongodb.support.query.DefaultQueryGenerator;
import com.jxdinfo.hussar.support.audit.plugin.mongodb.support.query.service.impl.MongoDBServiceImpl;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.support.Encrypt;
import com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class AuditColumnMongoCURDServiceImpl
extends MongoDBServiceImpl<AuditLogColumnEntity>
implements AuditColumnCURDService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditColumnMongoCURDServiceImpl.class);
    @Autowired(required=false)
    Encrypt encrypt;

    public IPage<AuditLogColumnEntity> listPage(AuditLogColumnEntity auditLogColumnEntity, Page<AuditLogColumnEntity> page, HttpServletRequest req) {
        DefaultQueryGenerator defaultQueryGenerator = new DefaultQueryGenerator();
        Query query = defaultQueryGenerator.initMongoDbQuery(auditLogColumnEntity, req.getParameterMap());
        Page<AuditLogColumnEntity> pageList = this.page(page, query, AuditLogColumnEntity.class);
        List auditLogColumnEntityList = pageList.getRecords();
        if (HussarUtils.isNotEmpty((Object)auditLogColumnEntityList)) {
            for (AuditLogColumnEntity entity : auditLogColumnEntityList) {
                if (!HussarUtils.isNotEmpty((Object)entity.getAnnotationInfo())) continue;
                try {
                    boolean isEncrypt;
                    JSONObject annotationInfo = JSON.parseObject((String)entity.getAnnotationInfo());
                    if (annotationInfo.containsKey((Object)"isEncrypt") && HussarUtils.isNotEmpty((Object)this.encrypt) && (isEncrypt = annotationInfo.getBoolean("isEncrypt").booleanValue())) {
                        entity.setBeforeValue(this.encrypt.decrypt(entity.getBeforeValue()));
                        entity.setAfterValue(this.encrypt.decrypt(entity.getAfterValue()));
                    }
                    TransUtil.transByCondition((Object)entity, (JSONObject)JSON.parseObject((String)entity.getAnnotationInfo()));
                }
                catch (Exception e) {
                    LOGGER.warn("\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8ffd\u8e2a\u5b57\u5178\u7ffb\u8bd1\u5f02\u5e38\uff0c{}\uff0c[{}]", (Object)entity.getAnnotationInfo(), (Object)e.getMessage());
                }
            }
        }
        return pageList;
    }

    public List<AuditLogColumnEntity> list(AuditLogColumnEntity auditLogColumnEntity, HttpServletRequest req) {
        DefaultQueryGenerator defaultQueryGenerator = new DefaultQueryGenerator();
        Query query = defaultQueryGenerator.initMongoDbQuery(auditLogColumnEntity, req.getParameterMap());
        return this.list(query, AuditLogColumnEntity.class);
    }

    public List<Map> listGroupList(AuditLogColumnEntity auditLogColumnEntity, Map<String, String[]> map) {
        String collectionName;
        DefaultQueryGenerator defaultQueryGenerator = new DefaultQueryGenerator();
        List<AggregationOperation> aggregationOperationsList = defaultQueryGenerator.initMongoAggregation(auditLogColumnEntity, map);
        Aggregation aggregation = Aggregation.newAggregation(aggregationOperationsList);
        AggregationResults aggregate = this.mongoTemplate.aggregate(aggregation, collectionName = this.mongoTemplate.getCollectionName(auditLogColumnEntity.getClass()), Map.class);
        if (HussarUtils.isEmpty((Object)aggregate) || HussarUtils.isEmpty((Object)aggregate.getMappedResults())) {
            return new ArrayList<Map>();
        }
        return aggregate.getMappedResults();
    }
}

