/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.mongodb.support.service;

import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogEntity;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogTableEntity;
import com.jxdinfo.hussar.support.audit.core.auditlog.service.AuditLogService;
import com.jxdinfo.hussar.support.audit.core.auditlog.vo.AuditLogItemVo;
import com.jxdinfo.hussar.support.audit.plugin.mongodb.service.AuditLogColumnMongoService;
import com.jxdinfo.hussar.support.audit.plugin.mongodb.service.AuditLogMongoService;
import com.jxdinfo.hussar.support.audit.plugin.mongodb.service.AuditLogTableMongoService;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;

public class AuditMongoServiceImpl
implements AuditLogService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditMongoServiceImpl.class);
    @Autowired
    private AuditLogMongoService auditLogMongoService;
    @Autowired
    private AuditLogTableMongoService auditLogTableMongoService;
    @Autowired
    private AuditLogColumnMongoService auditLogColumnMongoService;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    SeqBuilder seqBuilder;

    public void saveAuditLogDataChanges(List<AuditLogItemVo> auditLogItemVos) {
        if (HussarUtils.isEmpty(auditLogItemVos)) {
            LOGGER.warn("\u5ba1\u8ba1\u65e5\u5fd7\u6570\u636e\u53d8\u5316\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u4fdd\u5b58\u6570\u636e");
            return;
        }
        for (AuditLogItemVo auditLogItemVo : auditLogItemVos) {
            AuditLogTableEntity auditLogTable = auditLogItemVo.getAuditLogTable();
            auditLogTable.setId(Long.valueOf(this.seqBuilder.build().nextValue()));
            this.auditLogTableMongoService.save(auditLogTable);
            Set auditLogColumnSet = auditLogItemVo.getAuditLogColumnSet();
            if (HussarUtils.isNotEmpty((Object)auditLogColumnSet)) {
                auditLogColumnSet.stream().forEach(auditLogColumnEntity -> {
                    auditLogColumnEntity.setTableId(auditLogTable.getId());
                    auditLogColumnEntity.setId(Long.valueOf(this.seqBuilder.build().nextValue()));
                });
            }
            this.auditLogColumnMongoService.saveBatch(auditLogColumnSet);
        }
    }

    public boolean save(AuditLogEntity entity) {
        return this.auditLogMongoService.save(entity);
    }

    public boolean udateByCommit(AuditLogEntity entity) {
        return this.auditLogMongoService.save(entity);
    }
}

