/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.mongodb.support.query.rule.query.strategy;

import com.jxdinfo.hussar.platform.core.utils.DateTimeUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.plugin.mongodb.support.query.entity.FieldMappingDto;
import com.jxdinfo.hussar.support.audit.plugin.mongodb.support.query.rule.query.QueryStrategy;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.data.mongodb.core.query.Criteria;

public class InQueryStrategy
implements QueryStrategy {
    @Override
    public FieldMappingDto transFieldValue(FieldMappingDto fieldMappingDto) {
        Object fieldValue = fieldMappingDto.getFieldValue();
        if (HussarUtils.isEmpty((Object)fieldValue)) {
            return fieldMappingDto;
        }
        String value = fieldValue.toString();
        switch (fieldMappingDto.getFieldClassType().toString()) {
            case "class java.lang.Integer": {
                ArrayList integerList = new ArrayList();
                Arrays.stream(value.split(",")).forEach(s -> {
                    if (HussarUtils.isNotEmpty((Object)s) && HussarUtils.isNotEmpty((Object)s.trim())) {
                        integerList.add(Integer.parseInt(s));
                    }
                });
                fieldMappingDto.setFieldValue(integerList);
                break;
            }
            case "class java.lang.Short": {
                ArrayList shortList = new ArrayList();
                Arrays.stream(value.split(",")).forEach(s -> {
                    if (HussarUtils.isNotEmpty((Object)s) && HussarUtils.isNotEmpty((Object)s.trim())) {
                        shortList.add(Short.parseShort(s));
                    }
                });
                fieldMappingDto.setFieldValue(shortList);
                break;
            }
            case "class java.lang.Long": {
                ArrayList longList = new ArrayList();
                Arrays.stream(value.split(",")).forEach(s -> {
                    if (HussarUtils.isNotEmpty((Object)s) && HussarUtils.isNotEmpty((Object)s.trim())) {
                        longList.add(Long.parseLong(s));
                    }
                });
                fieldMappingDto.setFieldValue(longList);
                break;
            }
            case "class java.lang.Float": {
                ArrayList floatList = new ArrayList();
                Arrays.stream(value.split(",")).forEach(s -> {
                    if (HussarUtils.isNotEmpty((Object)s) && HussarUtils.isNotEmpty((Object)s.trim())) {
                        floatList.add(Float.valueOf(Float.parseFloat(s)));
                    }
                });
                fieldMappingDto.setFieldValue(floatList);
                break;
            }
            case "class java.lang.Double": {
                ArrayList doubles = new ArrayList();
                Arrays.stream(value.split(",")).forEach(s -> {
                    if (HussarUtils.isNotEmpty((Object)s) && HussarUtils.isNotEmpty((Object)s.trim())) {
                        doubles.add(Double.parseDouble(s));
                    }
                });
                fieldMappingDto.setFieldValue(doubles);
                break;
            }
            case "class java.math.BigDecimal": {
                ArrayList bigDecimals = new ArrayList();
                Arrays.stream(value.split(",")).forEach(s -> {
                    if (HussarUtils.isNotEmpty((Object)s) && HussarUtils.isNotEmpty((Object)s.trim())) {
                        bigDecimals.add(new BigDecimal((String)s));
                    }
                });
                fieldMappingDto.setFieldValue(bigDecimals);
                break;
            }
            case "class java.time.LocalDate": {
                ArrayList localDates = new ArrayList();
                Arrays.stream(value.split(",")).forEach(s -> {
                    if (HussarUtils.isNotEmpty((Object)s) && HussarUtils.isNotEmpty((Object)s.trim())) {
                        localDates.add(DateTimeUtil.parseDate((String)s));
                    }
                });
                fieldMappingDto.setFieldValue(localDates);
                break;
            }
            case "class java.time.LocalDateTime": {
                ArrayList localDateTimes = new ArrayList();
                Arrays.stream(value.split(",")).forEach(s -> {
                    if (HussarUtils.isNotEmpty((Object)s) && HussarUtils.isNotEmpty((Object)s.trim())) {
                        localDateTimes.add(DateTimeUtil.parseDateTime((String)s));
                    }
                });
                fieldMappingDto.setFieldValue(localDateTimes);
                break;
            }
            case "class java.time.LocalTime": {
                ArrayList localTimes = new ArrayList();
                Arrays.stream(value.split(",")).forEach(s -> {
                    if (HussarUtils.isNotEmpty((Object)s) && HussarUtils.isNotEmpty((Object)s.trim())) {
                        localTimes.add(DateTimeUtil.parseTime((String)s));
                    }
                });
                fieldMappingDto.setFieldValue(localTimes);
                break;
            }
            case "class java.lang.Boolean": {
                ArrayList booleans = new ArrayList();
                Arrays.stream(value.split(",")).forEach(s -> {
                    if (HussarUtils.isNotEmpty((Object)s) && HussarUtils.isNotEmpty((Object)s.trim())) {
                        booleans.add(Boolean.valueOf(s));
                    }
                });
                fieldMappingDto.setFieldValue(booleans);
            }
            default: {
                ArrayList strings = new ArrayList();
                Arrays.stream(value.split(",")).forEach(s -> {
                    if (HussarUtils.isNotEmpty((Object)s) && HussarUtils.isNotEmpty((Object)s.trim())) {
                        strings.add(s);
                    }
                });
                fieldMappingDto.setFieldValue(strings);
            }
        }
        return fieldMappingDto;
    }

    @Override
    public void joinQueryWrapper(List<Criteria> criteriaList, FieldMappingDto fieldMappingDto) {
        String name = fieldMappingDto.getColumnName();
        Object value = fieldMappingDto.getFieldValue();
        if (HussarUtils.isEmpty((Object)value) || HussarUtils.isEmpty((Object)name)) {
            return;
        }
        criteriaList.add(Criteria.where((String)fieldMappingDto.getColumnName()).in((Collection)value));
    }
}

