/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.mongodb.support.query;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.ReflectUtil;
import com.jxdinfo.hussar.support.audit.plugin.mongodb.support.query.entity.FieldMappingDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public abstract class QueryGenerator {
    private static final Logger log = LoggerFactory.getLogger(QueryGenerator.class);
    private static final List<String> filterFieldList = new ArrayList<String>();

    public List<AggregationOperation> initMongoAggregation(Object searchObj, Map<String, String[]> parameterMap) {
        List<AggregationOperation> aggregationOperationList = this.createAggregationOperation(searchObj, parameterMap);
        return aggregationOperationList;
    }

    protected abstract List<AggregationOperation> createAggregationOperation(Object var1, Map<String, String[]> var2);

    protected abstract List<Criteria> createQueryWrapper(Object var1, Map<String, String[]> var2);

    public Query initMongoDbQuery(Object searchObj, Map<String, String[]> parameterMap) {
        Sort orders;
        long start = System.currentTimeMillis();
        Query queryWrapper = new Query();
        List<Criteria> criteriaList = this.createQueryWrapper(searchObj, parameterMap);
        if (HussarUtils.isNotEmpty(criteriaList)) {
            Criteria[] criteria = criteriaList.toArray(new Criteria[criteriaList.size()]);
            queryWrapper.addCriteria((CriteriaDefinition)new Criteria().andOperator(criteria));
        }
        if (HussarUtils.isNotEmpty((Object)(orders = this.doMultiFieldOrder(searchObj, parameterMap)))) {
            queryWrapper.with(orders);
        }
        log.debug("---\u67e5\u8be2\u6761\u4ef6\u6784\u9020\u5668\u521d\u59cb\u5316\u5b8c\u6210,\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2----");
        return queryWrapper;
    }

    protected boolean judgedIsUselessField(String fieldName) {
        return filterFieldList.contains(fieldName);
    }

    protected String getMongoDocumentFieldName(Class<?> clazz, String name) {
        Field field = (Field)ReflectUtil.getAnnotation(clazz, (String)name, Field.class);
        if (HussarUtils.isNotEmpty((Object)field) && HussarUtils.isNotEmpty((Object)field.name())) {
            return field.name();
        }
        return name;
    }

    protected abstract void doCreateQuery(List<Criteria> var1, Map<String, String[]> var2, FieldMappingDto var3, Object var4);

    protected abstract Sort doMultiFieldOrder(Object var1, Map<String, String[]> var2);

    static {
        filterFieldList.add("class");
        filterFieldList.add("ids");
        filterFieldList.add("page");
        filterFieldList.add("rows");
        filterFieldList.add("sort");
        filterFieldList.add("order");
    }
}

