/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dynamictable.service.impl;

import com.jxdinfo.hussar.platform.core.utils.date.format.DatePattern;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.service.ShardingRule;
import java.time.LocalDateTime;
import java.util.Date;
import org.springframework.util.ObjectUtils;

public class DayShardingRule
implements ShardingRule {
    private final String MATCH_REGEX = "^\\d{4}(0[1-9]|1[0-2])(0[1-9]|[12]\\d|3[01])$";

    @Override
    public boolean checkRule(String suffix) {
        return org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)suffix) && suffix.matches("^\\d{4}(0[1-9]|1[0-2])(0[1-9]|[12]\\d|3[01])$");
    }

    @Override
    public String getDefaultSuffix() {
        return LocalDateTime.now().format(DatePattern.PURE_DATE_FORMATTER);
    }

    @Override
    public String getByObject(Object obj) {
        if (ObjectUtils.isEmpty((Object)obj)) {
            return null;
        }
        if (obj instanceof Long) {
            obj = new Date((Long)obj);
        }
        if (obj instanceof LocalDateTime) {
            return DatePattern.PURE_DATE_FORMATTER.format((LocalDateTime)obj);
        }
        if (obj instanceof Date) {
            return DatePattern.PURE_DATE_FORMAT.format((Date)obj);
        }
        return null;
    }
}

