/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dynamictable.processor;

import com.jxdinfo.hussar.support.audit.plugin.dynamictable.enums.ShardingRuleEnum;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.processor.DynamicTableProcessor;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.service.ShardingRule;
import org.springframework.util.ObjectUtils;

public abstract class SimpleDynamicTableProcessor
implements DynamicTableProcessor {
    private ShardingRule shardingRule;
    private String oldTableName;

    public SimpleDynamicTableProcessor() {
    }

    public SimpleDynamicTableProcessor(String oldTableName, ShardingRuleEnum shardingRuleEnum) {
        this.setOldTableName(oldTableName);
        this.setShardingRuleService(shardingRuleEnum.getShardingRule());
    }

    @Override
    public String changeSuffix(Object obj) {
        if (ObjectUtils.isEmpty((Object)this.shardingRule)) {
            return String.valueOf(obj);
        }
        if (obj instanceof String && this.shardingRule.checkRule((String)obj)) {
            return (String)obj;
        }
        String suffix = this.shardingRule.getByObject(obj);
        if (ObjectUtils.isEmpty((Object)suffix)) {
            return this.shardingRule.getDefaultSuffix();
        }
        return suffix;
    }

    @Override
    public String getOldTableName() {
        return this.oldTableName;
    }

    public void setOldTableName(String oldTableName) {
        this.oldTableName = oldTableName;
    }

    public void setShardingRuleService(ShardingRule shardingRule) {
        this.shardingRule = shardingRule;
    }
}

