/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis.interceptor;

import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.TableNameParser;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.jxdinfo.hussar.support.audit.core.support.dynamictable.DynamicTableHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.util.ObjectUtils;

public class DynamicTableNameCustomizerInnerInterceptor
implements InnerInterceptor {
    private Runnable hook;
    private List<DynamicTableHandler> tableNameHandlers;

    public void setHook(Runnable hook) {
        this.hook = hook;
    }

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (!InterceptorIgnoreHelper.willIgnoreDynamicTableName((String)ms.getId())) {
            PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
            mpBs.sql(this.changeTable(mpBs.sql()));
        }
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.INSERT || sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE || sct == SqlCommandType.SELECT) {
            if (InterceptorIgnoreHelper.willIgnoreDynamicTableName((String)ms.getId())) {
                return;
            }
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            mpBs.sql(this.changeTable(mpBs.sql()));
        }
    }

    protected String changeTable(String sql) {
        ExceptionUtils.throwMpe((boolean)ObjectUtils.isEmpty(this.tableNameHandlers), (String)"Please implement TableNameHandler processing logic", (Object[])new Object[0]);
        TableNameParser parser = new TableNameParser(sql);
        ArrayList names = new ArrayList();
        parser.accept(names::add);
        StringBuilder builder = new StringBuilder();
        int last = 0;
        for (TableNameParser.SqlToken name : names) {
            int start = name.getStart();
            if (start != last) {
                builder.append(sql, last, start);
                String tableName = name.getValue();
                for (DynamicTableHandler tableNameHandler : this.tableNameHandlers) {
                    tableName = tableNameHandler.dynamicTableName(tableName);
                }
                builder.append(tableName);
            }
            last = name.getEnd();
        }
        if (last != sql.length()) {
            builder.append(sql.substring(last));
        }
        if (this.hook != null) {
            this.hook.run();
        }
        return builder.toString();
    }

    public Runnable getHook() {
        return this.hook;
    }

    public List<DynamicTableHandler> getTableNameHandler() {
        return this.tableNameHandlers;
    }

    public void setTableNameHandler(List<DynamicTableHandler> tableNameHandlers) {
        this.tableNameHandlers = tableNameHandlers;
    }
}

