/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis;

import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataTable;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.platform.core.utils.collection.Pair;
import com.jxdinfo.hussar.support.audit.core.util.DataSourceUtil;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.enums.ShardingRuleEnum;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis.factory.BaseBuildTableService;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis.factory.BuildTableFactory;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.processor.SimpleDynamicTableProcessor;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public abstract class MybatisTableBuildService
extends SimpleDynamicTableProcessor {
    Logger log = LoggerFactory.getLogger(MybatisTableBuildService.class);
    private final int MAX_LENGTH = 30;

    public MybatisTableBuildService() {
    }

    public MybatisTableBuildService(String oldTableName, ShardingRuleEnum shardingRuleEnum) {
        super(oldTableName, shardingRuleEnum);
    }

    abstract MetadataParam getTableMetaDataInfo(String var1);

    @Override
    public boolean checkTableNameExist(String newTableName, Pair<String, String> schemaTableName) {
        return org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)this.selectTablesByTableNames(newTableName, schemaTableName));
    }

    @Override
    public boolean createTable(String newTableName, Pair<String, String> schemaTableName) {
        DataSource dataSource = (DataSource)SpringContextUtil.getBean(DataSource.class);
        ItemDataSource itemDataSource = DataSourceUtil.getCurrentItemSource((DataSource)dataSource);
        if (itemDataSource == null) {
            this.log.error("\u83b7\u53d6\u6570\u636e\u5e93\u94fe\u63a5\u5f02\u5e38");
            return false;
        }
        DbType dbType = itemDataSource.getDbType();
        BaseBuildTableService action = BuildTableFactory.getAction(dbType);
        action.buildNewTableByOldTable(newTableName, schemaTableName, () -> this.getTableMetaDataInfo(newTableName));
        return true;
    }

    private MetadataTable selectTablesByTableNames(String tableName, Pair<String, String> schemaTableName) {
        HussarDdlService hussarDdlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        List tableMetaData = hussarDdlService.selectTablesByTableNames(Collections.singletonList(tableName), "master");
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)tableMetaData)) {
            return (MetadataTable)tableMetaData.get(0);
        }
        return null;
    }

    protected String getIndexName(String pre, String newTableName) {
        if (ObjectUtils.isEmpty((Object)pre)) {
            pre = "id_";
        }
        if (pre.length() >= 30) {
            return pre.substring(0, 30);
        }
        return pre + StringUtil.cutFromEnd((String)newTableName, (int)(30 - pre.length()));
    }
}

